<?php

App::import('Vendor','completterslfpdf'); 

$pdf = new CompletterslfPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	$pdf->SetAuthor("Testmetrix at https://e-testmetrix.ca");
	$pdf->SetFont("helvetica", "", 11);
	$pdf->xheadertext = 'Testmetrix';
	$pdf->xfootertext = 'Copyright Testmetrix. All rights reserved.';

	//$pdf->SetProtection($permissions=array('copy','modify','annot-forms'), $user_pass='', $owner_pass=null, $mode=0, $pubkeys=null);	
	
	//set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);	
	
	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);	
	
    // add a page
    $pdf->AddPage();
	// Now you position and print your page content

	$pdf->SetTextColor(0, 0, 0);

	$gendertitle = '';
	$subjectname = '';
	$serviceEnd = '';
	
	$j = 0;
	
	//Montreal, February 19, 2012
	if (date("m") == '01'){
		$month_fra = 'janvier';
	} elseif (date("m") == '02') {
		$month_fra = 'février';
	} elseif (date("m") == '03') {
		$month_fra = 'mars';
	} elseif (date("m") == '04') {
		$month_fra = 'avril';
	} elseif (date("m") == '05') {
		$month_fra = 'mai';
	} elseif (date("m") == '06') {
		$month_fra = 'juin';
	} elseif (date("m") == '07') {
		$month_fra = 'juillet';
	} elseif (date("m") == '08') {
		$month_fra = 'août';
	} elseif (date("m") == '09') {
		$month_fra = 'septembre';
	} elseif (date("m") == '10') {
		$month_fra = 'octobre';
	} elseif (date("m") == '11') {
		$month_fra = 'novembre';
	} elseif (date("m") == '12') {
		$month_fra = 'décembre';
	}	

	$gendertitle = $infoCustomerEmpEvalOrder['Requester']['first_name'].' '.$infoCustomerEmpEvalOrder['Requester']['last_name'].' :';

	$datelettre = 'Montréal, le '.date("d").' '.$month_fra.', '.date("Y");	

	$subjecttitle = $labelsComplSLFLetter[0]['DocLabel']['name_fre'].'/'.$labelsComplSLFLetter[0]['DocLabel']['name_eng'].'<br/><br/>';
	
	$codepostalF = substr($infoCustomerEmpEvalOrder['Customer']['code_postal'], 0, 3).' '.substr($infoCustomerEmpEvalOrder['Customer']['code_postal'], 3, 3);

	$addresslettre = '';
	$addresslettre .= $infoCustomerEmpEvalOrder['Requester']['first_name'].' '.$infoCustomerEmpEvalOrder['Requester']['last_name'].'<br/>';
	$addresslettre .= $infoCustomerEmpEvalOrder['Customer']['name'].'<br/>';
	$addresslettre .= $infoCustomerEmpEvalOrder['Customer']['address'].'<br/>';
	$addresslettre .= $infoCustomerEmpEvalOrder['City']['name'].', '.$infoCustomerEmpEvalOrder['Province']['name'].'<br/>';
	$addresslettre .= $codepostalF.'<br/>';
	
	$customername = strtoupper($infoCustomerEmpEvalOrder['Customer']['name']);
	$subjectname .= $infoCustomerEmpEvalOrder['Employee']['first_name'].' '.$infoCustomerEmpEvalOrder['Employee']['last_name'].'<br/>';
	$subjectname .= '<b>'.$labelsComplSLFLetter[1]['DocLabel']['name_fre'].'<br/>'.$labelsComplSLFLetter[1]['DocLabel']['name_eng'].'</b>';
	$subjectname .= '&nbsp;&nbsp;&nbsp;'.$infoCustomerEmpEvalOrder['Customer']['abbrv'].' - '.$infoCustomerEmpEvalOrder['Order']['order_code'].'<br/>';	
	
	# First page
	$pdf->xDateLetter = $datelettre;
	$pdf->xAddressLetter = $addresslettre;
	$pdf->HeadingLetter();
	
	$pdf->xSubjectTitle = '<u><b>'.$subjecttitle.'</b></u><br/>';
	$pdf->xCustomerSubject = $subjectname;
	$pdf->SubjectLetter();
	//echo pr($labelsComplSLFLetter);
	$pdf->xGenderTitle = $gendertitle.'<br/>';
	$pdf->ComplLetterSlfContent($labelsComplSLFLetter);

	$addressTMX = '4333, rue Ste-Catherine o., Bureau 410, Montréal (Québec) H3Z 1P9 Tél: (514) 938-4166 Fax: (514) 938-5268';
	$pdf->xAddressTestmetrix = $addressTMX;
	
	$AdminTitle = 'Cristina Garza';	
	
	$pdf->EndLetter($AdminTitle);
	
	echo $pdf->Output('Tmx-ClaimLetter'.$infoCustomerEmpEvalOrder['Customer']['abbrv'].'-'.$infoCustomerEmpEvalOrder['Order']['order_code'].'.pdf', 'D');
	
			//Aaron may 27-2016
	// line 77 lacks .pdf extension as in the following exemple:
	//$//this->Pdf->core->Output('example_001.pdf', 'D');
	//this causes the output file not to be recognized as pdf by the 
	//downloading computer...
	
?>