<?php

App::import('Vendor','incomplletterpdf'); 

$pdf = new IncomplletterPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	$pdf->SetAuthor("Testmetrix at https://e-testmetrix.ca");
	$pdf->SetFont("helvetica", "", 11);
	$pdf->xheadertext = 'Testmetrix';
	$pdf->xfootertext = 'Copyright Testmetrix. All rights reserved.';

	//$pdf->SetProtection($permissions=array('copy','modify','annot-forms'), $user_pass='', $owner_pass=null, $mode=0, $pubkeys=null);	
	
	//set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);	
	
	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);	
	
    // add a page
    $pdf->AddPage();
	// Now you position and print your page content

	$pdf->SetTextColor(0, 0, 0);
	
	//
//	echo $lang_id;
	$fieldname = '';
	$gendertitle = '';
	$subjectname = '';
	$serviceEnd = '';
	
	$j = 0;
	
	if ($lang_id == 0)
	{
		$fieldname = 'name_fre';
		//Montreal, February 19, 2012
		if (date("m") == '01'){
			$month_fra = 'janvier';
		} elseif (date("m") == '02') {
			$month_fra = 'février';
		} elseif (date("m") == '03') {
			$month_fra = 'mars';
		} elseif (date("m") == '04') {
			$month_fra = 'avril';
		} elseif (date("m") == '05') {
			$month_fra = 'mai';
		} elseif (date("m") == '06') {
			$month_fra = 'juin';
		} elseif (date("m") == '07') {
			$month_fra = 'juillet';
		} elseif (date("m") == '08') {
			$month_fra = 'août';
		} elseif (date("m") == '09') {
			$month_fra = 'septembre';
		} elseif (date("m") == '10') {
			$month_fra = 'octobre';
		} elseif (date("m") == '11') {
			$month_fra = 'novembre';
		} elseif (date("m") == '12') {
			$month_fra = 'décembre';
		}	
//test_serie
		if ($infoEmployeeEvalOrder['Employee']['gender'] == 'F')
		{
			$gendertitle = 'Chère madame ';
		} elseif ($infoEmployeeEvalOrder['Employee']['gender'] == 'M')
		{
			$gendertitle = 'Cher monsieur ';
		}
		
		$datelettre = 'Montréal, le '.date("d").' '.$month_fra.', '.date("Y");
		$subjecttitle = 'OBJET:';
		//$subjectname = 'NUMÉRO DE DOSSIER À TESTMETRIX: ';		
		//$pharmasection = 'PharmÉlite Prochaines Étapes :';
		$serviceEnd = 'Ci-joint :';
	}	
	if ($lang_id == 1)
	{
		if ($infoEmployeeEvalOrder['Employee']['gender'] == 'F')
		{
			$gendertitle = 'Dear Ms. ';
		} elseif ($infoEmployeeEvalOrder['Employee']['gender'] == 'M')
		{
			$gendertitle = 'Dear Mr. ';
		}
		
		$fieldname = 'name_eng';
		$datelettre =  'Montreal, '.date("F j, Y"); 
		$subjecttitle = 'RE:';
		//$subjectname = 'TESTMETRIX FILE NUMBER: ';
		//$pharmasection = 'PharmÉlite Next Steps:';
		$serviceEnd = 'ENCL : ';
	}	

	$subjectname = $labelsIncomplLetter[0]['DocLabel'][$fieldname];
	
	$codepostalF = substr($infoEmployeeEvalOrder['Employee']['code_postal'], 0, 3).' '.substr($infoEmployeeEvalOrder['Employee']['code_postal'], 3, 3);

	$addresslettre = '';
	$addresslettre .= $infoEmployeeEvalOrder['Employee']['first_name'].' '.$infoEmployeeEvalOrder['Employee']['last_name'].'<br/>';
	$addresslettre .= $infoEmployeeEvalOrder['Employee']['address'].'<br/>';
	$addresslettre .= $infoEmployeeEvalOrder['City']['name'].', '.$infoEmployeeEvalOrder['Province']['name'].'<br/>';
	$addresslettre .= $codepostalF.'<br/>';
	
	$customername = strtoupper($infoEmployeeEvalOrder['Customer']['name']);
	$subjectname .= $infoEmployeeEvalOrder['Customer']['abbrv'].' - '.$infoEmployeeEvalOrder['Order']['order_code'];
	$gendertitle .= $infoEmployeeEvalOrder['Employee']['last_name'].',';		
	
	# First page
	$pdf->xDateLetter = $datelettre;
	$pdf->xAddressLetter = $addresslettre;
	$pdf->HeadingLetter();
	
	$pdf->xSubjectTitle = '<u><b>'.$subjecttitle.'</b></u><br/>';
	$pdf->xCustomerSubject = '<b>'.$customername.'<br/>'.$subjectname.'</b>';
	$pdf->SubjectLetter();
	
	$pdf->xGenderTitle = $gendertitle.'<br/>';
	$pdf->IncomplLetterContent($labelsIncomplLetter, $fieldname, $customername);

	$addressTMX = '4333, rue Ste-Catherine o., Bureau 410, Montréal (Québec) H3Z 1P9 Tél: (514) 938-4166 Fax: (514) 938-5268';
	$pdf->xAddressTestmetrix = $addressTMX;
	
	$drTitle = 'Ronald D. Brown, M.D.FRCPC';	
	//$drTitle = $labelsIncomplLetter[6]['DocLabel'][$fieldname];
	
	$letterCCend = 'cc :'.$infoEmployeeEvalOrder['Requester']['name'].', '.$infoEmployeeEvalOrder['Customer']['name'];
	$serviceEnd .=$infoEmployeeEvalOrder['Service']['name'];
	$pdf->EndLetter($letterCCend, $drTitle, $serviceEnd);
	
	echo $pdf->Output('Tmx-ClaimLetter'.$infoEmployeeEvalOrder['Customer']['abbrv'].'-'.$infoEmployeeEvalOrder['Order']['order_code'].'pdf', 'D');
	
	//Aaron may 27-2016
	// line 77 lacks .pdf extension as in the following exemple:
	//$//this->Pdf->core->Output('example_001.pdf', 'D');
	//this causes the output file not to be recognized as pdf by the 
	//downloading computer...
	
?>