<?php

App::import('Vendor','treatquestpdf'); 

$pdf = new TreatquestPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	$pdf->SetAuthor("Testmetrix at https://e-testmetrix.ca");
	$pdf->SetFont("helvetica", "", 11);
	$pdf->xheadertext = 'Testmetrix';
	$pdf->xfootertext = 'Copyright Testmetrix. All rights reserved.';

	if ($this->Session->read('Auth.User.group_id') == 2 || $this->Session->read('Auth.User.group_id') == 3) {
		$pdf->SetProtection($permissions=array('copy','modify','annot-forms'), $user_pass='', $owner_pass=null, $mode=0, $pubkeys=null);	
	}
	//set margins
	#$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	$pdf->SetMargins(10, PDF_MARGIN_TOP, 10);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);	
	
	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);	
	
    // add a page
    $pdf->AddPage();
	// Now you position and print your page content

	$pdf->SetTextColor(0, 0, 0);
	
	$fieldname = '';
	$gendername = '';
	$subjectname = '';
	$refsText = '';
	$refCita = 0;
	$ref138 = 0;
	$ref153	= 0;
	
	$test_serie = $infoCustomerEvalorder['Evaluation']['test_serie'];
	
	$j = 0;
	#$infoCustomerEvalorder['Evaluation']['status_date'];
	#date("m")
	$test_month = date("m", strtotime($infoCustomerEvalorder['Evaluation']['status_date']));
	if ($lang_id == 0) {
		$fieldname = 'name_fre';
		//Montreal, February 19, 2012
		//echo date("m");
		switch($test_month) {
			case('01'):
				$month_fra = 'janvier';
				break;
			case('02'):
				$month_fra = 'février';
				break;
			case('03'):
				$month_fra = 'mars'; 
				break;
			case('04'):
				$month_fra = 'avril';
				break;
			case('05'):
				$month_fra = 'mai';
				break;
			case('06'):
				$month_fra = 'juin';
				break;				
			case('07'):
				$month_fra = 'juillet';
				break;
			case('08'):
				$month_fra = 'août';
				break;
			case('09'):
				$month_fra = 'septembre';
				break;
			case('10'):
				$month_fra = 'octobre';
				break;
			case('11'):
				$month_fra = 'novembre';
				break;
			case('12'):
				$month_fra = 'décembre';
				break;								
		}		
		
		$datelettre = 'Montréal, le '.date("d", strtotime($infoCustomerEvalorder['Evaluation']['status_date'])).' '.$month_fra.', '.date("Y", strtotime($infoCustomerEvalorder['Evaluation']['status_date']));
		$subjecttitle = 'OBJET:';
		$subjectname = 'NUMÉRO DE DOSSIER À TESTMETRIX: ';
		$pharmasection = 'PharmÉlite Prochaines Étapes :';
		$letterend = 'Les prochaines étapes de PharmÉlite fournissent des données de mesure et des conseils pharmacologiques aux médecins traitants pour aider à maintenir une ligne directrice des soins concordants pour les troubles dépressifs et autres troubles psychiatriques. Ces renseignements ne sont pas destinés à remplacer les conseils médicaux offerts par les médecins. Ce rapport a été généré électroniquement. Compte tenu de la possibilité d\'erreurs humaines et des risques inhérents aux rapports électroniques, il peut y avoir des omissions ou des inexactitudes dans ces informations.';
	}	
	if ($lang_id == 1) {
		$fieldname = 'name_eng';
		#$datelettre =  'Montreal, '.date("F j, Y"); 
		$datelettre =  'Montreal, '.date("F j, Y", strtotime($infoCustomerEvalorder['Evaluation']['status_date'])); 
		$subjecttitle = 'RE:';
		$subjectname = 'TESTMETRIX FILE NUMBER: ';
		$pharmasection = 'PharmÉlite Next Steps:';
		$letterend = 'The PharmÉlite Next Steps provides measurement data and pharmacological guidance to treating physicians to aide in maintaining guideline concordant care for depressive and other psychiatric disorders. This information is not intended to replace medical advice offered by physicians. This report has been generated electronically. In view of the possibility of human error and the inherent hazards of electronic reports, there may be omissions or inaccuracies in such information.';	
	}	

	$codepostalF = substr($infoCustomerEvalorder['Customer']['code_postal'], 0, 3).' '.substr($infoCustomerEvalorder['Customer']['code_postal'], 3, 3);
	
	$addresslettre = '';
	$addresslettre .= $infoCustomerEvalorder['Requester']['name'].'<br/>';
	$addresslettre .= $infoCustomerEvalorder['Customer']['name'].'<br/>';
	$addresslettre .= $infoCustomerEvalorder['Customer']['address'].'<br/>';
	$addresslettre .= $infoCustomerEvalorder['City']['name'].', '.$infoCustomerEvalorder['Province']['name'].'<br/>';
	$addresslettre .= $codepostalF.'<br/>';
	$patientname = $html->fullUpper($infoCustomerEvalorder['Employee']['first_name']).' '.$html->fullUpper($infoCustomerEvalorder['Employee']['last_name']).' '.$infoCustomerEvalorder['Employee']['customer_internalcode'];
	$subjectname .= $infoCustomerEvalorder['Customer']['abbrv'].' - '.$infoCustomerEvalorder['Order']['order_code'].' - Test '.$test_serie;
	
	//%20
	$strfilename = '';
	$strfilename .= $html->fullUpper($infoCustomerEvalorder['Employee']['first_name'])." ".$html->fullUpper($infoCustomerEvalorder['Employee']['last_name'])." ".$infoCustomerEvalorder['Employee']['customer_internalcode']." ";
	$strfilename .= 'Test'.$test_serie;
	
	# First page
	$pdf->xDateLetter = $datelettre;
	$pdf->xAddressLetter = $addresslettre;
	$pdf->HeadingLetter(); 	
	
	$pdf->xSubjectTitle = '<u><b>'.$subjecttitle.'</b></u><br/>';
	$pdf->xPatientSubject = '<b>'.$patientname.'<br/>'.$subjectname.'</b>';
	$pdf->SubjectLetter(); 		
	
	if (!empty($interpDoctorLetter[0])) {
		$pdf->DoctorInterpGSection($interpDoctorLetter[0]);		
	}	

	#Ref Texte
	if (!empty($interpDoctorLetter[3])) {
		$ctrlbr = 0;
		$symbolRef = 1;
		foreach ($interpDoctorLetter[3] as $refs):
			if ($ctrlbr == count($interpDoctorLetter[3]) - 1) { 
				$br = ' ';
			} else {
				$br = '<br/>';
			} 		
			if ($refs['id'] == 180 || $refs['id'] == 181 || $refs['id'] == 182) {
				if($refs['id'] == 180) { $refCita = 1; }
				if($refs['id'] == 181) { $ref138 = 1; }
				if($refs['id'] == 182) { $ref153 = 1; }
				$refsText .= '<font size="-4"><sup>'.$symbolRef.'</sup> '.$refs['texte'].'</font>'.$br; 
			}
			$symbolRef++;
		endforeach;		
	}	
	
	if (!empty($interpDoctorLetter[1])) {
		$pdf->xTitleSection = '<b>'.$pharmasection.'</b><br/>';
		$ctrlbr = 0;
		if (!empty($interpDoctorLetter[2])) {	//stopped meds
			$listeStoppedMeds = '';
			$leftStoppedMeds = '';
			$rightStoppedMeds = '';			
			foreach ($interpDoctorLetter[2] as $s):
				# Create content columns - meds that were stopped
				if ($ctrlbr == count($interpDoctorLetter[2]) - 1) { 
					$br = ' ';
				} else {
					$br = '<br/>';
				} 
				$leftStoppedMeds .= $s['name'].'&nbsp;&nbsp;'.$s['customedose'].$br;
				$rightStoppedMeds .= $s['reasons'].$br;
				$ctrlbr++;
			endforeach;
			#echo $leftStoppedMeds;
			$pdf->xleftStoppedMeds = $leftStoppedMeds;
			$pdf->xrightStoppedMeds = $rightStoppedMeds;			
		}
		$pdf->DoctorInterpPSection($interpDoctorLetter[1], $ctrlbr, $refCita, $ref138, $ref153);
	}
	
	$drTitle = '';	
	$pdf->EndLetter($letterend, $drTitle, $refsText);
	$addressTMX = '4333, rue Ste-Catherine o., Bureau 410, Montréal (Québec) H3Z 1P9 Tél: (514) 938-4166  Fax: (514) 938-5268';
	$pdf->xAddressTestmetrix = $addressTMX;

//	echo $pdf->Output($patientname.' Test'.$test_serie, 'D');
		echo $pdf->Output($strfilename.'.pdf', 'D');

		//Aaron may 27-2016
	// line 77 lacks .pdf extension as in the following exemple:
	//$//this->Pdf->core->Output('example_001.pdf', 'D');
	//this causes the output file not to be recognized as pdf by the 
	//downloading computer...
?>