$(document).ready(function(){		
	
	var month_invoice = '';
	var year_invoice = '';
	month_invoice = $('#InvoiceInvoicedDateMonth').val();
	year_invoice = $('#InvoiceInvoicedDateYear').val();	
	
	//Criteria 1 - By Company
	if($('#InvoiceInvoiceType1').is(':checked')){
		$('#invoiceCriteria1').show();
		$('#invoiceCriteria2').hide();
		$('#invoiceCriteria3').hide();
	}
	
	//Criteria 2 - By Company / Team
	if($('#InvoiceInvoiceType2').is(':checked')){
		$('#invoiceCriteria1').show();
		$('#invoiceCriteria2').show();
		$('#invoiceCriteria3').hide();
	}	
	
	//Criteria 3 - By Requester / Company / Team
	if($('#InvoiceInvoiceType3').is(':checked')){
		$('#invoiceCriteria1').show();
		$('#invoiceCriteria2').show();
		$('#invoiceCriteria3').show();
		if($('#select-customer').val().length != 0) {
			customer = $('#select-customer');
			$.getJSON('/invoices/get_teams_ajax',{idcust:customer}, function(teams) {
				if(teams !== null) {
				  populateCustTeamsList(teams);
				}
			});		
	  }	
	}	
	
	//By Company  
	$('#InvoiceInvoiceType1').click(function() {
		$('#invoiceCriteria1').show();
		$('#invoiceCriteria2').hide();
		$('#invoiceCriteria3').hide();
	});
	
	//By Company / Team 
	$('#InvoiceInvoiceType2').click(function() {
		$('#invoiceCriteria1').show();
		$('#invoiceCriteria2').show();
		$('#invoiceCriteria3').hide();
	});	
	
	//By Requester / Company / Team 
	$('#InvoiceInvoiceType3').click(function() {
		$('#invoiceCriteria1').show();
		$('#invoiceCriteria2').show();
		$('#invoiceCriteria3').show();
	});		
	
	$('#select-customer').live('change', function() {
		if($(this).val().length != 0) {
			customer = $(this).val();
			$.getJSON('/invoices/get_teams_ajax',{idcust:customer}, function(teams) {
				if(teams !== null) {
				  populateCustTeamsList(teams);
				}
			});		
      }
    });
	
	$('#select-team').live('change', function() {
		if($(this).val().length != 0) {
			team = $(this).val();
			$.getJSON('/invoices/get_requesters_ajax',{idteam:team}, function(requesters) {
				if(requesters !== null) {
				  populateTeamRequesList(requesters);
				}
			});		
		}
    });	
	
	$('#InvoiceInvoicedDateMonth').live('change', function() {
		month_invoice = $('#InvoiceInvoicedDateMonth').val();
    });

	$('#InvoiceInvoicedDateYear').live('change', function() {
		year_invoice = $('#InvoiceInvoicedDateYear').val();
    });
	
  $('#submitInvoice').click(function() {
	customerx = $('#select-customer').val();
	teamx = $('#select-team').val(); 
	requesterx = $('#select-requester').val(); 
	if( $('#InvoiceInvoiceType1').is(":not(':checked')") && $('#InvoiceInvoiceType2').is(":not(':checked')") && $('#InvoiceInvoiceType3').is(":not(':checked')")) {
		alert('Please select an Invoice criteria.');
		return false
	}else{
		if(month_invoice.length > 0 && year_invoice.length > 0){
			var d = new Date();
			var monthdate = d.getMonth() + 1;	
			var yeardate = d.getFullYear();		
			
			if((parseInt(month_invoice) < monthdate && parseInt(year_invoice) == yeardate) || 
			   (parseInt(month_invoice) > monthdate && parseInt(year_invoice) < yeardate)){			
				//Criteria 1 - By Company
				if($('#InvoiceInvoiceType1').is(':checked')){
					if (!$('#select-customer').val()) {
						alert('Please select a Customer.');
						return false			
					}
				}else{
					//Criteria 2 - By Company / Team
					if($('#InvoiceInvoiceType2').is(':checked')){
						if (!$('#select-customer').val() || !$('#select-team').val()) {
							alert('Please select a Customer/Team.');
							return false
						}
					}	
					//Criteria 3 - By Requester / Company / Team
					if($('#InvoiceInvoiceType3').is(':checked')){
						if (!$('#select-customer').val() || !$('#select-team').val() || !$('#select-requester').val()) {
							alert('Please select a Customer/Team/Requester.');
							return false
						}
					}			
				}				
			} else {
				alert('Sorry, it is not the end of the month yet.');
				return false					
			}
		} else {
			alert('Please select a Invoice Month/Year.');
			return false					
		}
		$('#InvoiceCreateInvoiceForm').submit();
	} 
  });
});

function populateCustTeamsList(teams) {
	var options = '';
		options += '<option value="">..... Select one .....</option>'
	 
		$.each(teams, function(index, team) {
			options += '<option value="' + index + '">' + team + '</option>';
		});
		
	$('#select-team').html(options);
}

function populateTeamRequesList(requesters) {
	var options = '';
		options += '<option value="">..... Select one .....</option>'
	 
		$.each(requesters, function(index, requester) {
			options += '<option value="' + index + '">' + requester + '</option>';
		});
		
	$('#select-requester').html(options);
}