	(function( $ ) {
		$.widget( "ui.combobox", {
			_create: function() {
				var self = this,
					select = this.element.hide(),
					selected = select.children( ":selected" ),
					value = selected.val() ? selected.text() : "";
				var input = this.input = $( "<input>" )
					.insertAfter( select )
					.val( value )
					.autocomplete({
						delay: 0,
						minLength: 0,
						source: function( request, response ) {
							var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
							response( select.children( "option" ).map(function() {
								var text = $( this ).text();
								if ( this.value && ( !request.term || matcher.test(text) ) )
									return {
										label: text.replace(
											new RegExp(
												"(?![^&;]+;)(?!<[^<>]*)(" +
												$.ui.autocomplete.escapeRegex(request.term) +
												")(?![^<>]*>)(?![^&;]+;)", "gi"
											), "<strong>$1</strong>" ),
										value: text,
										option: this
									};
							}) );
						},
						select: function( event, ui ) {
							ui.item.option.selected = true;
							self._trigger( "selected", event, {
								item: ui.item.option
							});
						},
						change: function( event, ui ) {
							if ( !ui.item ) {
								var matcher = new RegExp( "^" + $.ui.autocomplete.escapeRegex( $(this).val() ) + "$", "i" ),
									valid = false;
								select.children( "option" ).each(function() {
									if ( $( this ).text().match( matcher ) ) {
										this.selected = valid = true;
										return false;
									}
								});
								if ( !valid ) {
									// remove invalid value, as it didn't match anything
									$( this ).val( "" );
									select.val( "" );
									input.data( "autocomplete" ).term = "";
//									input.data( "autocomplete" ).term = $( this ).val();
									return false;
								}
							}
						}
					})
					.addClass( "ui-widget ui-widget-content ui-corner-left" );

				input.data( "autocomplete" )._renderItem = function( ul, item ) {
					return $( "<li></li>" )
						.data( "item.autocomplete", item )
						.append( "<a>" + item.label + "</a>" )
						.appendTo( ul );
				};

				this.button = $( "<button type='button'>&nbsp;</button>" )
					.attr( "tabIndex", -1 )
					.attr( "title", "Show All Items" )
					.insertAfter( input )
					.button({
						icons: {
							primary: "ui-icon-triangle-1-s"
						},
						text: false						
					})
					.removeClass( "ui-corner-all" )
					.addClass( "ui-corner-right ui-button-icon" )
					.click(function() {
						// close if already visible
						if ( input.autocomplete( "widget" ).is( ":visible" ) ) {
							input.autocomplete( "close" );
							return;
						}

						// work around a bug (likely same cause as #5265)
						$( this ).blur();

						// pass empty string as value to search for, displaying all results
						input.autocomplete( "search", "" );
						input.focus();
					});
			input.attr( 'id', $(select).attr( 'id' )+'-input' );
		
			},

			destroy: function() {
				this.input.remove();
				this.button.remove();
				this.element.show();
				$.Widget.prototype.destroy.call( this );
			}
		});
	})( jQuery );
	
$(document).ready(function(){

	for (var i = 0; i < 10; i++){
		$('#Medstemp'+i+'DrugId').combobox();		
	}	
	$(".numericdec").numeric();

	//Initial - Question 1 - if Yes then show-enable the rest of the questions 
	$('#QuestionnaireTreatmentTreatment1010').click(function() {	
		for (var i = 1; i < 7; i++){
			$('#treatquestsectionrow'+i+' :input').prop('disabled', false);
		}				
	});
	
	//FollowUp - Question 1 - if Yes then show-enable the rest of the questions 
	$('#QuestionnaireTreatmentTreatment1044').click(function() {
		for (var i = 1; i < 5; i++){
			$('#treatquestsectionrow'+i+' :input').prop('disabled', false);
		}		
	});		
	
	// Initial - Question 1 - if No then disabled  
	$('#QuestionnaireTreatmentTreatment1011').click(function() {
		for (var i = 0; i < 5; i++){
			a = i + 1;
			$('#treatquestsectionrow'+a+' :input').prop('disabled', true);
			$('#Medstemp'+i+'DrugId-input').val('');
			$('#Medstemp'+i+'CustomeDose').val('');
			$('#Medstemp'+i+'Customemeds').val('');
			$('#Medstemp'+i+'DayTDay').val('');
			$('#Medstemp'+i+'MonthTMonth').val('');
			$('#Medstemp'+i+'YearTYear').val('');
			$('#Medstemp'+i+'Newmed').prop('checked', false);
		}	
		for (var i = 19; i < 33; i++){
			$('#QuestionnaireTreatmentSideEffectsChaine'+i).prop('checked', false);
		}
		for (var i = 1; i < 6; i++){
			$('#treatquestsectionrow'+i+' :input').prop('disabled', true);
		}			
		$('#QuestionnaireTreatmentSideEffects1016').prop('checked', false);
		$('#QuestionnaireTreatmentSideEffects1017').prop('checked', false);
		$('#QuestionnaireTreatmentStopingDrugs1018').prop('checked', false);
		$('#QuestionnaireTreatmentStopingDrugs1019').prop('checked', false);
		for (var i = 0; i < 5; i++){
			$('#Medstemp'+i+'More5years').prop('checked', false);
		}						
		$('#qsttreat_improv2').val('');		
	});	
	
	//FollowUp - Question 1 - if No then disabled  
	$('#QuestionnaireTreatmentTreatment1045').click(function() {
		for (var i = 0; i < 5; i++){
			a = i + 1;
			if(a < 5) { $('#treatquestsectionrow'+a+' :input').prop('disabled', true); }			
			$('#Medstemp'+i+'DrugId-input').val('');
			$('#Medstemp'+i+'CustomeDose').val('');			
			$('#Medstemp'+i+'Customemeds').val('');
			$('#Medstemp'+i+'DayTDay').val('');
			$('#Medstemp'+i+'MonthTMonth').val('');
			$('#Medstemp'+i+'YearTYear').val('');			
			$('#Medstemp'+i+'Newmed').prop('checked', false);			
		}	
		for (var i = 33; i < 47; i++){
			$('#QuestionnaireTreatmentSideEffectsChaine'+i).prop('checked', false);
		}		
		for (var i = 1; i < 5; i++){
			$('#treatquestsectionrow'+i+' :input').prop('disabled', true);
		}		
		$('#QuestionnaireTreatmentSideEffects1049').prop('checked', false);
		$('#QuestionnaireTreatmentSideEffects1050').prop('checked', false);
		$('#QuestionnaireTreatmentStopingDrugs1051').prop('checked', false);
		$('#QuestionnaireTreatmentStopingDrugs1052').prop('checked', false);
		for (var i = 0; i < 5; i++){
			$('#Medstemp'+i+'More5years').prop('checked', false);
		}		
	});

	//Initial - Question 2 Enable the Custome Meds textbox					
	$('#Medstemp0Newmed').click(function() {
		if($('#Medstemp0Newmed').is(':checked')){				
			$('#customemeds0').show();
			$('#Medstemp0DrugId-input').val('');
			$('#Medstemp0Customemeds').focus().val('');			
		}else{
			$('#customemeds0').hide();
			$('#Medstemp0Customemeds').val('');
			$('#Medstemp0DrugId-input').focus().val('');
		}
	});	
	$('#Medstemp1Newmed').click(function() {
		if($('#Medstemp1Newmed').is(':checked')){				
			$('#customemeds1').show();
			$('#Medstemp1DrugId-input').val('');
			$('#Medstemp1Customemeds').focus().val('');			
		}else{
			$('#customemeds1').hide();
			$('#Medstemp1Customemeds').val('');
			$('#Medstemp1DrugId-input').focus().val('');			
		}
	});	
	$('#Medstemp2Newmed').click(function() {
		if($('#Medstemp2Newmed').is(':checked')){				
			$('#customemeds2').show();
			$('#Medstemp2DrugId-input').val('');
			$('#Medstemp2Customemeds').focus().val('');			
		}else{
			$('#customemeds2').hide();
			$('#Medstemp2Customemeds').val('');
			$('#Medstemp2DrugId-input').focus().val('');			
		}
	});	
	$('#Medstemp3Newmed').click(function() {
		if($('#Medstemp3Newmed').is(':checked')){				
			$('#customemeds3').show();
			$('#Medstemp3DrugId-input').val('');
			$('#Medstemp3Customemeds').focus().val('');			
		}else{
			$('#customemeds3').hide();
			$('#Medstemp3Customemeds').val('');
			$('#Medstemp3DrugId-input').focus().val('');			
		}
	});	
	$('#Medstemp4Newmed').click(function() {
		if($('#Medstemp4Newmed').is(':checked')){				
			$('#customemeds4').show();
			$('#Medstemp4DrugId-input').val('');
			$('#Medstemp4Customemeds').focus().val('');			
		}else{
			$('#customemeds4').hide();
			$('#Medstemp4Customemeds').val('');
			$('#Medstemp4DrugId-input').focus().val('');			
		}
	});	
	$('#Medstemp5Newmed').click(function() {
		if($('#Medstemp5Newmed').is(':checked')){				
			$('#customemeds5').show();
			$('#Medstemp5DrugId-input').val('');
			$('#Medstemp5Customemeds').focus().val('');			
		}else{
			$('#customemeds5').hide();
			$('#Medstemp5Customemeds').val('');
			$('#Medstemp5DrugId-input').focus().val('');			
		}
	});		
	$('#Medstemp6Newmed').click(function() {
		if($('#Medstemp6Newmed').is(':checked')){				
			$('#customemeds6').show();
			$('#Medstemp6DrugId-input').val('');
			$('#Medstemp6Customemeds').focus().val('');			
		}else{
			$('#customemeds6').hide();
			$('#Medstemp6Customemeds').val('');
			$('#Medstemp6DrugId-input').focus().val('');			
		}
	});	
	$('#Medstemp7Newmed').click(function() {
		if($('#Medstemp7Newmed').is(':checked')){				
			$('#customemeds7').show();
			$('#Medstemp7DrugId-input').val('');
			$('#Medstemp7Customemeds').focus().val('');			
		}else{
			$('#customemeds7').hide();
			$('#Medstemp7Customemeds').val('');
			$('#Medstemp7DrugId-input').focus().val('');			
		}
	});		
	$('#Medstemp8Newmed').click(function() {
		if($('#Medstemp8Newmed').is(':checked')){
			$('#customemeds8').show();
			$('#Medstemp8DrugId-input').val('');
			$('#Medstemp8Customemeds').focus().val('');			
		}else{
			$('#customemeds8').hide();
			$('#Medstemp8Customemeds').val('');
			$('#Medstemp8DrugId-input').focus().val('');			
		}
	});	
	$('#Medstemp9Newmed').click(function() {
		if($('#Medstemp9Newmed').is(':checked')){				
			$('#customemeds9').show();
			$('#Medstemp9DrugId-input').val('');
			$('#Medstemp9Customemeds').focus().val('');			
		}else{
			$('#customemeds9').hide();
			$('#Medstemp9Customemeds').val('');
			$('#Medstemp9DrugId-input').focus().val('');			
		}
	});	
	
	//Initial - Question 2 Checkbox More then 5 years	
	$('#Medstemp0More5years').click(function() {
		if($('#Medstemp0More5years').is(':checked')) {
			$('#Medstemp0DayTDay').val('');
			$('#Medstemp0MonthTMonth').val('');
			$('#Medstemp0YearTYear').val('');
			$('#Medstemp0DayTDay').prop('disabled', true);
			$('#Medstemp0MonthTMonth').prop('disabled', true);
			$('#Medstemp0YearTYear').prop('disabled', true);
		}else{
			$('#Medstemp0DayTDay').prop('disabled', false);
			$('#Medstemp0MonthTMonth').prop('disabled', false);
			$('#Medstemp0YearTYear').prop('disabled', false);
		}
	});		
	$('#Medstemp1More5years').click(function() {
		if($('#Medstemp1More5years').is(':checked')){	
			$('#Medstemp1DayTDay').val('');
			$('#Medstemp1MonthTMonth').val('');
			$('#Medstemp1YearTYear').val('');		
			$('#Medstemp1DayTDay').prop('disabled', true);
			$('#Medstemp1MonthTMonth').prop('disabled', true);
			$('#Medstemp1YearTYear').prop('disabled', true);
		}else{
			$('#Medstemp1DayTDay').prop('disabled', false);
			$('#Medstemp1MonthTMonth').prop('disabled', false);
			$('#Medstemp1YearTYear').prop('disabled', false);
		}
	});		
	$('#Medstemp2More5years').click(function() {
		if($('#Medstemp2More5years').is(':checked')){	
			$('#Medstemp2DayTDay').val('');
			$('#Medstemp2MonthTMonth').val('');
			$('#Medstemp2YearTYear').val('');		
			$('#Medstemp2DayTDay').prop('disabled', true);
			$('#Medstemp2MonthTMonth').prop('disabled', true);
			$('#Medstemp2YearTYear').prop('disabled', true);
		}else{
			$('#Medstemp2DayTDay').prop('disabled', false);
			$('#Medstemp2MonthTMonth').prop('disabled', false);
			$('#Medstemp2YearTYear').prop('disabled', false);
		}
	});
	$('#Medstemp3More5years').click(function() {
		if($('#Medstemp3More5years').is(':checked')){	
			$('#Medstemp3DayTDay').val('');
			$('#Medstemp3MonthTMonth').val('');
			$('#Medstemp3YearTYear').val('');		
			$('#Medstemp3DayTDay').prop('disabled', true);
			$('#Medstemp3MonthTMonth').prop('disabled', true);
			$('#Medstemp3YearTYear').prop('disabled', true);
		}else{
			$('#Medstemp3DayTDay').prop('disabled', false);
			$('#Medstemp3MonthTMonth').prop('disabled', false);
			$('#Medstemp3YearTYear').prop('disabled', false);
		}
	});	
	
	$('#Medstemp4More5years').click(function() {
		if($('#Medstemp4More5years').is(':checked')){	
			$('#Medstemp4DayTDay').val('');
			$('#Medstemp4MonthTMonth').val('');
			$('#Medstemp4YearTYear').val('');		
			$('#Medstemp4DayTDay').prop('disabled', true);
			$('#Medstemp4MonthTMonth').prop('disabled', true);
			$('#Medstemp4YearTYear').prop('disabled', true);
		}else{
			$('#Medstemp4DayTDay').prop('disabled', false);
			$('#Medstemp4MonthTMonth').prop('disabled', false);
			$('#Medstemp4YearTYear').prop('disabled', false);
		}
	});
	
	$('#Medstemp0DrugId-input').click(function() {			
			$('#customemeds0').hide();			
			$("#Medstemp0Newmed").removeAttr("checked"); 
	});
	
	$('#Medstemp1DrugId-input').click(function() {			
			$('#customemeds1').hide();			
			$("#Medstemp1Newmed").removeAttr("checked"); 
	}); 
	
	$('#Medstemp2DrugId-input').click(function() {			
			$('#customemeds2').hide();			
			$("#Medstemp2Newmed").removeAttr("checked"); 
	});
	
	$('#Medstemp3DrugId-input').click(function() {			
			$('#customemeds3').hide();			
			$("#Medstemp3Newmed").removeAttr("checked"); 
	});
	
	$('#Medstemp4DrugId-input').click(function() {			
			$('#customemeds4').hide();			
			$("#Medstemp4Newmed").removeAttr("checked"); 
	}); 
	
	//Initial - Question 8 - if Yes then show nonprescripcompounds textbox
	$('#QuestionnaireTreatmentNonprescripCompounds1024').click(function() {
			$('#nonprescripcompounds').show();
	}); 
	
	//Initial - Question 8 - if Non then hide nonprescripcompounds textbox
	$('#QuestionnaireTreatmentNonprescripCompounds1025').click(function() {
			$('#QuestionnaireTreatmentNonprescripCompoundsName').val('');
			$('#nonprescripcompounds').hide();
	});  
	
	//FollowUp - Question 6 - if Yes then show nonprescripcompounds textbox
	$('#QuestionnaireTreatmentNonprescripCompounds1054').click(function() {
			$('#nonprescripcompounds').show();
	}); 	  
	
	//FollowUp - Question 6 - if Non then hide nonprescripcompounds textbox
	$('#QuestionnaireTreatmentNonprescripCompounds1055').click(function() {
			$('#QuestionnaireTreatmentNonprescripCompoundsName').val('');
			$('#nonprescripcompounds').hide();
	});	

	//Initial - Question 4 - if No then disable Question 5 and 6
	$('#QuestionnaireTreatmentSideEffects1017').click(function() {
		$('#QuestionnaireTreatmentStopingDrugs1018').attr('checked', false);
		$('#QuestionnaireTreatmentStopingDrugs1019').attr('checked', false);		
		$('#QuestionnaireTreatmentSideEffectsChaine19').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine20').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine21').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine22').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine23').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine24').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine25').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine26').removeAttr('checked');		
		$('#QuestionnaireTreatmentSideEffectsChaine27').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine28').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine29').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine30').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine31').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine32').removeAttr('checked');		
		$('#treatquestsectionrow4 :input').attr('disabled', true);
		$('#treatquestsectionrow5 :input').attr('disabled', true);
		$('#customesideeff').hide();
	});
	
	//Initial - Question 4 - if Yes then show-enable Question 5 and 6
	$('#QuestionnaireTreatmentSideEffects1016').click(function() {		
		//$('#treatquestsectionrow5 :input').removeAttr('disabled');
		$('#treatquestsectionrow4 :input').prop('disabled', false);
		$('#treatquestsectionrow5 :input').prop('disabled', false);
	});		
	
	//FollowUp - Question 3 - if Yes then show-enable Question 4 and 5
	$('#QuestionnaireTreatmentSideEffects1049').click(function() {
		$('#treatquestsectionrow4 :input').prop('disabled', false);
		$('#treatquestsectionrow3 :input').prop('disabled', false);
	});		
	
	//Followup - Question 3 - if No then disable Question 4 and 5
	$('#QuestionnaireTreatmentSideEffects1050').click(function() {
		$('#QuestionnaireTreatmentStopingDrugs1051').attr('checked', false);
		$('#QuestionnaireTreatmentStopingDrugs1052').attr('checked', false);		
		$('#QuestionnaireTreatmentSideEffectsChaine33').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine34').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine35').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine36').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine37').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine38').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine39').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine40').removeAttr('checked');		
		$('#QuestionnaireTreatmentSideEffectsChaine41').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine42').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine43').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine44').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine45').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine46').removeAttr('checked');		
		$('#treatquestsectionrow4 :input').attr('disabled', true);
		$('#treatquestsectionrow3 :input').attr('disabled', true);
		$('#customesideeff').hide();
	});	   
  
	//Initial - Question 5 - if No then disable Question 6
	$('#QuestionnaireTreatmentStopingDrugs1019').click(function() {
		$('#treatquestsectionrow5 :input').attr('disabled', true);
		$('#QuestionnaireTreatmentSideEffectsChaine19').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine20').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine21').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine22').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine23').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine24').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine25').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine26').removeAttr('checked');		
		$('#QuestionnaireTreatmentSideEffectsChaine27').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine28').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine29').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine30').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine31').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine32').removeAttr('checked');
		$('#customesideeff').hide();		
	});	
	
	//Initial - Question 5 - if Yes then enable Question 6
	$('#QuestionnaireTreatmentStopingDrugs1018').click(function() {
		$('#treatquestsectionrow5 :input').prop('disabled', false);
	});	
		
	//FollowUp - Question 4 - if No then disable Question 5
	$('#QuestionnaireTreatmentStopingDrugs1052').click(function() {
		$('#treatquestsectionrow4 :input').attr('disabled', true);
		$('#QuestionnaireTreatmentSideEffectsChaine33').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine34').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine35').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine36').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine37').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine38').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine39').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine40').removeAttr('checked');		
		$('#QuestionnaireTreatmentSideEffectsChaine41').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine42').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine43').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine44').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine45').removeAttr('checked');
		$('#QuestionnaireTreatmentSideEffectsChaine46').removeAttr('checked');
		$('#customesideeff').hide();
	});	
	
	//FollowUp - Question 4 - if Yes then enable Question 5
	$('#QuestionnaireTreatmentStopingDrugs1051').click(function() {
		$('#treatquestsectionrow4 :input').prop('disabled', false);
	});	
		
	//Initial - Question 7 Enable the Custome Side effects textbox
	$('#QuestionnaireTreatmentSideEffectsChaine32').click(function() {
		if($('#QuestionnaireTreatmentSideEffectsChaine32').is(':checked'))
		{
			$('#customesideeff').show();
		}else{
			$('#customesideeff').hide();
		}
	});
	
	//FollowUp - Question 5 Enable the Custome Side effects textbox
	$('#QuestionnaireTreatmentSideEffectsChaine46').click(function() {
		if($('#QuestionnaireTreatmentSideEffectsChaine46').is(':checked'))
		{
			$('#customesideeff').show();
		}else{
			$('#customesideeff').hide();
		}
	});	
  
	//Initial - Question 10 - if No then disabled Question11
	$('#QuestionnaireTreatmentPsychotherapy1040').click(function() {
		$('#treatquestsectionrow10 :input').attr('disabled', true);
		$('#thpywhom101').val('');
		$('#thpywhom102').val('');
		$('#thpywhom103').val('');
		$('#thpywhom104').val('');
		$('#thpywhom105').val('');
		
		$('#thpyfrec101').val('');
		$('#thpyfrec102').val('');
		$('#thpyfrec103').val('');
		$('#thpyfrec104').val('');
		$('#thpyfrec105').val('');

		$('#Therapytemp0DurationOfSession').val('');
		$('#Therapytemp1DurationOfSession').val('');
		$('#Therapytemp2DurationOfSession').val('');
		$('#Therapytemp3DurationOfSession').val('');
		$('#Therapytemp4DurationOfSession').val('');
	});
	if($('#QuestionnaireTreatmentPsychotherapy1040').is(':checked')){
		$('#treatquestsectionrow10 :input').attr('disabled', true);
	}
	
	//FollowUp - Question 8 - if No then disabled Question 9
	$('#QuestionnaireTreatmentPsychotherapy1070').click(function() {
		$('#treatquestsectionrow8 :input').attr('disabled', true);
		$('#thpywhom81').val('');
		$('#thpywhom82').val('');
		$('#thpywhom83').val('');
		$('#thpywhom84').val('');
		$('#thpywhom85').val('');
		
		$('#thpyfrec81').val('');
		$('#thpyfrec82').val('');
		$('#thpyfrec83').val('');
		$('#thpyfrec84').val('');
		$('#thpyfrec85').val('');

		$('#Therapytemp0DurationOfSession').val('');
		$('#Therapytemp1DurationOfSession').val('');
		$('#Therapytemp2DurationOfSession').val('');
		$('#Therapytemp3DurationOfSession').val('');
		$('#Therapytemp4DurationOfSession').val('');			
	});		
	if($('#QuestionnaireTreatmentPsychotherapy1070').is(':checked')){
		$('#treatquestsectionrow8 :input').attr('disabled', true);
	}
	
	//Initial - Question 10 - if Yes then show-enable Question11 
	$('#QuestionnaireTreatmentPsychotherapy1039').click(function() {
		$('#treatquestsectionrow10 :input').prop('disabled', false);
	});	 
	
	//FollowUp - Question 8 - if Yes then show-enable Question 9   
	$('#QuestionnaireTreatmentPsychotherapy1069').click(function() {
		$('#treatquestsectionrow8 :input').prop('disabled', false);
	});		
  
	//Initial - Question 11 Enable the Custome Therapy textbox
	$('#thpywhom101').live('change', function() {
		if($(this).val().length != 0) {
			typetherapist1 = $(this).val();
			if( typetherapist1 == 7 ) {
				$('#custometherapy1').show();
			}else{
				$('#custometherapy1').hide();
			}			
		}else{	
			$('#custometherapy1').hide();
		}	  
    });	
	
	$('#thpyfrec101').live('change', function() {
		if($(this).val().length != 0) {
			typeFtherapist1 = $(this).val();
			if( typeFtherapist1 == 6 ) {
				$('#customeFtherapy1').show();
			}else{
				$('#customeFtherapy1').hide();
			}			
		}else{	
			$('#customeFtherapy1').hide();
		}	  
    });	
	
	//FollowUp - Question 9 Enable the Custome Therapy textbox
	$('#thpywhom81').live('change', function() {
		if($(this).val().length != 0) {
			typetherapist1 = $(this).val();
			if( typetherapist1 == 14 ) {
				$('#custometherapy1').show();
			}else{
				$('#custometherapy1').hide();
			}			
		}else{	
			$('#custometherapy1').hide();
		}	  
    });	
	
	$('#thpyfrec81').live('change', function() {
		if($(this).val().length != 0) {
			typeFtherapist1 = $(this).val();
			if( typeFtherapist1 == 42 ) {
				$('#customeFtherapy1').show();
			}else{
				$('#customeFtherapy1').hide();
			}			
		}else{	
			$('#customeFtherapy1').hide();
		}	  
    });		

	//Initial - Question 11 Enable the Custome Therapy textbox
	$('#thpywhom102').live('change', function() {
		if($(this).val().length != 0) {
			typetherapist2 = $(this).val();
			if( typetherapist2 == 7 ) {
				$('#custometherapy2').show();
			}else{
				$('#custometherapy2').hide();
			}		
		}else{	
			$('#custometherapy2').hide();
		}	  
    });	
	$('#thpyfrec102').live('change', function() {
		if($(this).val().length != 0) {
			typeFtherapist2 = $(this).val();
			if( typeFtherapist2 == 6 ) {
				$('#customeFtherapy2').show();
			}else{
				$('#customeFtherapy2').hide();
			}		
		}else{	
			$('#customeFtherapy2').hide();
		}	  
    });		
	
	//FollowUp - Question 9 Enable the Custome Therapy textbox
	$('#thpywhom82').live('change', function() {
		if($(this).val().length != 0) {
			typetherapist2 = $(this).val();
			if( typetherapist2 == 14 ) {
				$('#custometherapy2').show();
			}else{
				$('#custometherapy2').hide();
			}		
		}else{	
			$('#custometherapy2').hide();
		}	  
    });	
	
	$('#thpyfrec82').live('change', function() {
		if($(this).val().length != 0) {
			typeFtherapist2 = $(this).val();
			if( typeFtherapist2 == 42 ) {
				$('#customeFtherapy2').show();
			}else{
				$('#customeFtherapy2').hide();
			}		
		}else{	
			$('#customeFtherapy2').hide();
		}	  
    });	
	
//Initial - Question 11 Enable the Custome Therapy textbox
  $('#thpywhom103').live('change', function() {
		if($(this).val().length != 0) {
			typetherapist3 = $(this).val();
			if( typetherapist3 == 7 ) {
				$('#custometherapy3').show();
			}else{
				$('#custometherapy3').hide();
			}		
		}else{	
			$('#custometherapy3').hide();
		}	  
    });	
  $('#thpyfrec103').live('change', function() {
		if($(this).val().length != 0) {
			typeFtherapist3 = $(this).val();
			if( typeFtherapist3 == 6 ) {
				$('#customeFtherapy3').show();
			}else{
				$('#customeFtherapy3').hide();
			}		
		}else{	
			$('#customeFtherapy3').hide();
		}	  
    });		
	
//FollowUp - Question 9 Enable the Custome Therapy textbox
  $('#thpywhom83').live('change', function() {
	if($(this).val().length != 0) {
		typetherapist3 = $(this).val();
		if( typetherapist3 == 14 ) {
			$('#custometherapy3').show();
		}else{
			$('#custometherapy3').hide();
		}		
	}else{	
		$('#custometherapy3').hide();
	}	  
    });	
	
  $('#thpyfrec83').live('change', function() {
	if($(this).val().length != 0) {
		typeFtherapist3 = $(this).val();
		if( typeFtherapist3 == 42 ) {
			$('#customeFtherapy3').show();
		}else{
			$('#customeFtherapy3').hide();
		}		
	}else{	
		$('#customeFtherapy3').hide();
	}	  
    });		
	
//Initial - Question 11 Enable the Custome Therapy textbox
  $('#thpywhom104').live('change', function() {
    if($(this).val().length != 0) {
		typetherapist4 = $(this).val();
		if( typetherapist4 == 7 ) {
			$('#custometherapy4').show();
		}else{
			$('#custometherapy4').hide();
		}			
	}else{	
		$('#custometherapy4').hide();
	}	  
    });	
	
  $('#thpyfrec104').live('change', function() {
    if($(this).val().length != 0) {
		typeFtherapist4 = $(this).val();
		if( typeFtherapist4 == 6 ) {
			$('#customeFtherapy4').show();
		}else{
			$('#customeFtherapy4').hide();
		}			
	}else{	
		$('#customeFtherapy4').hide();
	}	  
    });		
	
//FollowUp - Question 9 Enable the Custome Therapy textbox
  $('#thpywhom84').live('change', function() {
    if($(this).val().length != 0) {
		typetherapist4 = $(this).val();
		if( typetherapist4 == 14 ) {
			$('#custometherapy4').show();
		}else{
			$('#custometherapy4').hide();
		}			
	}else{	
		$('#custometherapy4').hide();
	}	  
    });		
	
  $('#thpyfrec84').live('change', function() {
    if($(this).val().length != 0) {
		typeFtherapist4 = $(this).val();
		if( typeFtherapist4 == 42 ) {
			$('#customeFtherapy4').show();
		}else{
			$('#customeFtherapy4').hide();
		}			
	}else{	
		$('#customeFtherapy4').hide();
	}	  
    });
	
//Initial - Question 11 Enable the Custome Therapy textbox
  $('#thpywhom105').live('change', function() {
	if($(this).val().length != 0) {
		typetherapist5 = $(this).val();
		if( typetherapist5 == 7 ) {
			$('#custometherapy5').show();
		}else{
			$('#custometherapy5').hide();
		}	
	}else{	
		$('#custometherapy5').hide();
	}
    });	
	
  $('#thpyfrec105').live('change', function() {
	if($(this).val().length != 0) {
		typeFtherapist5 = $(this).val();
		if( typeFtherapist5 == 6 ) {
			$('#customeFtherapy5').show();
		}else{
			$('#customeFtherapy5').hide();
		}	
	}else{	
		$('#customeFtherapy5').hide();
	}
    });		
	
//FollowUp - Question 9 Enable the Custome Therapy textbox
  $('#thpywhom85').live('change', function() {
	if($(this).val().length != 0) {
		typetherapist5 = $(this).val();
		if( typetherapist5 == 14 ) {
			$('#custometherapy5').show();
		}else{
			$('#custometherapy5').hide();
		}	
	}else{	
		$('#custometherapy5').hide();
	}
    });		
	
  $('#thpyfrec85').live('change', function() {
	if($(this).val().length != 0) {
		typeFtherapist5 = $(this).val();
		if( typeFtherapist5 == 42 ) {
			$('#customeFtherapy5').show();
		}else{
			$('#customeFtherapy5').hide();
		}	
	}else{	
		$('#customeFtherapy5').hide();
	}
    });		

	//QuestionnaireTreatmentAddForm  
	$('.submit').click(function() {	
		//Treatment Questionnaire Initial
		if ($('#QuestionnaireTreatmentQuestionnaireId').val() == 4) {
			$('#treatquestsectionrow0').removeAttr('style');
			$('#treatquestsectionrow2').removeAttr('style');
			$('#treatquestsectionrow3').removeAttr('style');
			$('#treatquestsectionrow4').removeAttr('style');
			$('#treatquestsectionrow5').removeAttr('style');			
			$('#treatquestsectionrow7').removeAttr('style');
			$('#treatquestsectionrow9').removeAttr('style');
			$('#thpywhom101').removeAttr('style');
			$('#thpyfrec101').removeAttr('style');
			$('#treatquestsectionrow0').css('border-bottom','1px solid #c8c8c8');
			$('#treatquestsectionrow2').css('border-bottom','1px solid #c8c8c8');
			$('#treatquestsectionrow3').css('border-bottom','1px solid #c8c8c8');
			$('#treatquestsectionrow4').css('border-bottom','1px solid #c8c8c8');
			$('#treatquestsectionrow5').css('border-bottom','1px solid #c8c8c8');			
			$('#treatquestsectionrow7').css('border-bottom','1px solid #c8c8c8');
			$('#treatquestsectionrow9').css('border-bottom','1px solid #c8c8c8');
            if(!validateTreatQuestInitial()) {
				return false;
            }
		}

		//Treatment Questionnaire Follow up
		if ($('#QuestionnaireTreatmentQuestionnaireId').val() == 5) {		
            if(!validateTreatQuestFollow()) {
				return false;
            }
		}
	});
});
 
function scrollToElement(selector, time, verticalOffset) {
    time = typeof(time) != 'undefined' ? time : 1000;
    verticalOffset = typeof(verticalOffset) != 'undefined' ? verticalOffset : 0;
    element = $(selector);
    offset = element.offset();
    offsetTop = offset.top + verticalOffset;
    $('html, body').animate({
        scrollTop: offsetTop
    }, time);
}
 
function validateTreatQuestInitial() {

	if( ($('#QuestionnaireTreatmentTreatment1011').is(":not(':checked')") && $('#QuestionnaireTreatmentTreatment1010').is(":not(':checked')")) ||
	($('#QuestionnaireTreatmentPsychotherapy1039').is(":not(':checked')") && $('#QuestionnaireTreatmentPsychotherapy1040').is(":not(':checked')"))) 
	{
		$('#treatquestsectionrow0').css('border','2px solid #FF0000');
		$('#treatquestsectionrow7').css('border','2px solid #FF0000');
		$('#treatquestsectionrow9').css('border','2px solid #FF0000');
		scrollToElement('#treatquestsectionrow0');		
		alert('You have to answer at least the Items 1, 8 and 10');		
		return false;
	} else {
		//Q.1 No
		if($('#QuestionnaireTreatmentTreatment1011').is(':checked')){	
			//Validate the Q.8 is not empty - NonprescripCompounds
			if ($('#QuestionnaireTreatmentNonprescripCompounds1024').is(":not(':checked')") && $('#QuestionnaireTreatmentNonprescripCompounds1025').is(":not(':checked')"))
			{
				$('#treatquestsectionrow7').css('border','2px solid #FF0000');
				scrollToElement('#treatquestsectionrow7');				
				alert('You have to answer question 8.');		
				return false;					
			}
			//Then validate if Q10 = Yes
			if($('#QuestionnaireTreatmentPsychotherapy1039').is(':checked')) {
				// Then make sure that at least one Therapy type has been selected.
				if( !$('#thpywhom101').val() && !$('#thpywhom102').val() && !$('#thpywhom103').val() && !$('#thpywhom104').val() && !$('#thpywhom105').val()) 
				{								
					$('#thpywhom101').css('border','2px solid #FF0000');
					$('#thpyfrec101').css('border','2px solid #FF0000');
					scrollToElement('#treatquestsectionrow10');	
					alert('Please fill out at least one type of therapy');
					return false;						
				}else{		
					for (var i=1; i<6; i++){
						a = i-1;
						// validate the values of the therapy select list
						if ($('#thpywhom10'+i).val() && !$('#thpyfrec10'+i).val()){
							$('#thpyfrec10'+i).css('border','2px solid #FF0000');
							alert('Please complete the marked item for the therapy row '+i);
							return false;						
						}								
						if ($('#thpywhom10'+i).val() == 7 && !$('#Therapytemp'+a+'Custometherapy').val()){
							$('#Therapytemp'+a+'Custometherapy'+i).css('background-color','#FF0000');
							alert('Please enter the Custome Therapy');
							return false;						
						}						
					}					
				}
			}
		}else{
		//Q.1 Yes
			// Then make sure that at least one Med-Drug type has been selected.

			if( !$('#Medstemp0DrugId').val() && !$('#Medstemp0Customemeds').val() && !$('#Medstemp1DrugId').val() && !$('#Medstemp1Customemeds').val() && 
				!$('#Medstemp2DrugId').val() && !$('#Medstemp2Customemeds').val() && !$('#Medstemp3DrugId').val() && !$('#Medstemp3Customemeds').val() &&				
				!$('#Medstemp4DrugId').val() && !$('#Medstemp4Customemeds').val())
			{
				$('#Medstemp0DrugId').css('border','2px solid #FF0000');
				scrollToElement('#treatquestsectionrow1');				
				alert('Please fill out at least one prescribed medication');
				return false;			
			}
			
			if(($('#QuestionnaireTreatmentNonprescripCompounds1024').is(":not(':checked')") && $('#QuestionnaireTreatmentNonprescripCompounds1025').is(":not(':checked')")) || 
				(!$('#qsttreat_improv2').val()) || ($('#QuestionnaireTreatmentSideEffects1016').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffects1017').is(":not(':checked')"))
				)
			{
				$('#treatquestsectionrow2').css('border','2px solid #FF0000');
				$('#treatquestsectionrow3').css('border','2px solid #FF0000');
				$('#treatquestsectionrow7').css('border','2px solid #FF0000');
				scrollToElement('#treatquestsectionrow2');				
				alert('Please complete all the missing items (3,4,8)');
				return false;					
			}
			
			//Q.4 Yes - check for an answer to the Q.5
			if($('#QuestionnaireTreatmentSideEffects1016').is(':checked') && $('#QuestionnaireTreatmentStopingDrugs1018').is(":not(':checked')")
				&& $('#QuestionnaireTreatmentStopingDrugs1019').is(":not(':checked')")) 
			{
				$('#treatquestsectionrow4').css('border','2px solid #FF0000');
				scrollToElement('#treatquestsectionrow4');				
				alert('Please complete the item 5');
				return false;				
			}
			
			//Q.5 Yes
			if($('#QuestionnaireTreatmentStopingDrugs1018').is(':checked')) {
				//Verifier that at least one side effect has been selected
				if ($('#QuestionnaireTreatmentSideEffectsChaine19').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine20').is(":not(':checked')") && 
					$('#QuestionnaireTreatmentSideEffectsChaine21').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine22').is(":not(':checked')") && 
					$('#QuestionnaireTreatmentSideEffectsChaine23').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine24').is(":not(':checked')") && 
					$('#QuestionnaireTreatmentSideEffectsChaine25').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine26').is(":not(':checked')") && 
					$('#QuestionnaireTreatmentSideEffectsChaine27').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine28').is(":not(':checked')") &&
					$('#QuestionnaireTreatmentSideEffectsChaine29').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine30').is(":not(':checked')") &&
					$('#QuestionnaireTreatmentSideEffectsChaine31').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine32').is(":not(':checked')"))
				{
					$('#treatquestsectionrow5').css('border','2px solid #FF0000');
					scrollToElement('#treatquestsectionrow5');								
					alert('Please select at least one side effect');
					return false;				
				}			
			}
			
			
			//Then validate if Q10 = Yes Psychotherapy
			if($('#QuestionnaireTreatmentPsychotherapy1039').is(':checked'))
			{
				// Then make sure that at least one Therapy type has been selected.
				if( !$('#thpywhom101').val() && !$('#thpywhom102').val() && !$('#thpywhom103').val() && !$('#thpywhom104').val() && !$('#thpywhom105').val()) 
				{
					$('#thpywhom101').css('border','2px solid #FF0000');
					alert('Please fill out at least one type of therapy.');
					return false;				
				}else{					
					for (var i=1; i<6; i++){
						a = i-1;
						// validate the values of the therapy select list
						if ($('#thpywhom10'+i).val() && !$('#thpyfrec10'+i).val())
						{
							$('#thpyfrec10'+i).css('border','2px solid #FF0000');
							alert('Please complete the marked item for the therapy row '+i);
							return false;						
						}								
						if ($('#thpywhom10'+i).val() == 7 && !$('#Therapytemp'+a+'Custometherapy').val())
						{
						
							$('#Therapytemp'+a+'Custometherapy'+i).css('background-color','#FF0000');
							alert('Please enter the Custome Therapy');
							return false;						
						}						
					}						
				}
			}			
		}
	}
	return true;
}

function validateTreatQuestFollow()  {

	//Validate the questions 1 and 8 are answered... 
	if( ($('#QuestionnaireTreatmentTreatment1045').is(":not(':checked')") && $('#QuestionnaireTreatmentTreatment1044').is(":not(':checked')")) ||
	($('#QuestionnaireTreatmentPsychotherapy1069').is(":not(':checked')") && $('#QuestionnaireTreatmentPsychotherapy1070').is(":not(':checked')"))) 
	{
		$('#treatquestsectionrow0').css('border','2px solid #FF0000');
		$('#treatquestsectionrow7').css('border','2px solid #FF0000');
		scrollToElement('#treatquestsectionrow0');				
		alert('You have to answer at least the questions 1. and 8.');		
		return false;
	} else{
		//Q.1 = No
		if($('#QuestionnaireTreatmentTreatment1045').is(':checked'))
		{			
			//Validate the Q.8 is not empty - NonprescripCompounds
			if ($('#QuestionnaireTreatmentNonprescripCompounds1054').is(":not(':checked')") && $('#QuestionnaireTreatmentNonprescripCompounds1055').is(":not(':checked')"))
			{
				alert('You have to answer the question 6.');		
				return false;					
			}

			//Q.8 Yes - Psychotherapy
			if($('#QuestionnaireTreatmentPsychotherapy1069').is(':checked'))
			{		
				// Then make sure that at least one Therapy type has been selected.
				if( !$('#thpywhom81').val() && !$('#thpywhom82').val() && !$('#thpywhom83').val() && !$('#thpywhom84').val() && !$('#thpywhom85').val()) 
				{
					alert('Please fill out at least one type of therapy');
					return false;				
				}else{					
					for (var i=1; i<6; i++)
					{
						a = i-1;
						// validate the values of the therapy select list
						if ($('#thpywhom8'+i).val() && !$('#thpyfrec8'+i).val())
						{
							$('#thpyfrec8'+i).css('border','2px solid #FF0000');
							alert('Please complete the marked item for the therapy row '+i);
							return false;						
						}								
						if ($('#thpywhom8'+i).val() == 7 && !$('#custometherapy'+i).val())
						{						
							$('#custometherapy'+i).css('background-color','#FF0000');
							alert('Please enter the Custome Therapy');
							return false;						
						}						
					}					
				}
			}					
		} 
		else
		{
		//Q.1 = Yes		
			//Validate the Q.2 is not empty (meds list...) 
			// Then make sure that at least one Med-Drug type has been selected.
			if( !$('#Medstemp0DrugId').val() && !$('#Medstemp0Customemeds').val() && !$('#Medstemp1DrugId').val() && !$('#Medstemp1Customemeds').val() && 
				!$('#Medstemp2DrugId').val() && !$('#Medstemp2Customemeds').val() && !$('#Medstemp3DrugId').val() && !$('#Medstemp3Customemeds').val() &&				
				!$('#Medstemp4DrugId').val() && !$('#Medstemp4Customemeds').val())
			{
				alert('Please fill out at least one prescribed medication');
				return false;			
			}			
		
			if(($('#QuestionnaireTreatmentNonprescripCompounds1054').is(":not(':checked')") && $('#QuestionnaireTreatmentNonprescripCompounds1055').is(":not(':checked')")) || 
				($('#QuestionnaireTreatmentSideEffects1049').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffects1050').is(":not(':checked')")) ||
				($('#QuestionnaireTreatmentPsychotherapy1069').is(":not(':checked')") && $('#QuestionnaireTreatmentPsychotherapy1070').is(":not(':checked')"))
				)
			{
				alert('Please complete all the missing items (3,6 and 8.)');
				return false;					
			}

			//Q.3 Yes - check for an answer to the Q.4
			if($('#QuestionnaireTreatmentSideEffects1049').is(':checked') && $('#QuestionnaireTreatmentStopingDrugs1051').is(":not(':checked')")
				&& $('#QuestionnaireTreatmentStopingDrugs1052').is(":not(':checked')")) 
			{
				$('#treatquestsectionrow2').css('border','2px solid #FF0000');
				scrollToElement('#treatquestsectionrow2');				
				alert('Please complete the item 3');
				return false;				
			}
			
			//Q.4 Yes
			if($('#QuestionnaireTreatmentStopingDrugs1051').is(':checked')) {
				//Verifier that at least one side effect has been selected
				if ($('#QuestionnaireTreatmentSideEffectsChaine33').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine34').is(":not(':checked')") && 
					$('#QuestionnaireTreatmentSideEffectsChaine35').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine36').is(":not(':checked')") && 
					$('#QuestionnaireTreatmentSideEffectsChaine37').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine38').is(":not(':checked')") && 
					$('#QuestionnaireTreatmentSideEffectsChaine39').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine40').is(":not(':checked')") && 
					$('#QuestionnaireTreatmentSideEffectsChaine41').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine42').is(":not(':checked')") &&
					$('#QuestionnaireTreatmentSideEffectsChaine43').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine44').is(":not(':checked')") &&
					$('#QuestionnaireTreatmentSideEffectsChaine45').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine46').is(":not(':checked')"))
				{
					alert('Please select at least one side effect');
					return false;				
				}			
			}

			//Q.8 Yes - Psychotherapy
			if($('#QuestionnaireTreatmentPsychotherapy1069').is(':checked'))
			{		
				// Then make sure that at least one Therapy type has been selected.
				if( !$('#thpywhom81').val() && !$('#thpywhom82').val() && !$('#thpywhom83').val() && !$('#thpywhom84').val() && !$('#thpywhom85').val()) 
				{
					$('#thpywhom81').css('border','2px solid #FF0000');				
					alert('Please fill out at least one type of therapy');
					return false;				
				}
				else
				{					
					for (var i=1; i<6; i++)
					{
						a = i-1;
						// validate the values of the therapy select list
						if ($('#thpywhom8'+i).val() && !$('#thpyfrec8'+i).val())
						{
							$('#thpyfrec8'+i).css('border','2px solid #FF0000');
							alert('Please complete the marked item for the therapy row '+i);
							return false;						
						}								
						if ($('#thpywhom8'+i).val() == 7 && !$('#custometherapy'+i).val())
						{						
							$('#custometherapy'+i).css('background-color','#FF0000');
							alert('Please enter the Custome Therapy');
							return false;						
						}						
					}					
				}
			}			
		
		}				

	}		
	return true;
}