(function( $ ) {
    $.widget( "ui.combobox", {
        _create: function() {
            var self = this,
                select = this.element.hide(),
                selected = select.children( ":selected" ),
                value = selected.val() ? selected.text() : "";
            var input = this.input = $( "<input>" )
                .insertAfter( select )
                .val( value )
                .autocomplete({
                    delay: 0,
                    minLength: 0,
                    source: function( request, response ) {
                        var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
                        response( select.children( "option" ).map(function() {
                            var text = $( this ).text();
                            if ( this.value && ( !request.term || matcher.test(text) ) )
                                return {
                                    label: text.replace(
                                        new RegExp(
                                            "(?![^&;]+;)(?!<[^<>]*)(" +
                                            $.ui.autocomplete.escapeRegex(request.term) +
                                            ")(?![^<>]*>)(?![^&;]+;)", "gi"
                                        ), "<strong>$1</strong>" ),
                                    value: text,
                                    option: this
                                };
                        }) );
                    },
                    select: function( event, ui ) {
                        ui.item.option.selected = true;
                        self._trigger( "selected", event, {
                            item: ui.item.option
                        });
                    },
                    change: function( event, ui ) {
                        if ( !ui.item ) {
                            var matcher = new RegExp( "^" + $.ui.autocomplete.escapeRegex( $(this).val() ) + "$", "i" ),
                                valid = false;
                            select.children( "option" ).each(function() {
                                if ( $( this ).text().match( matcher ) ) {
                                    this.selected = valid = true;
                                    return false;
                                }
                            });
                            if ( !valid ) {
                                // remove invalid value, as it didn't match anything
                                $( this ).val( "" );
                                select.val( "" );
                                input.data( "autocomplete" ).term = "";
//									input.data( "autocomplete" ).term = $( this ).val();
                                return false;
                            }
                        }
                    }
                })
                .addClass( "ui-widget ui-widget-content ui-corner-left" );

            input.data( "autocomplete" )._renderItem = function( ul, item ) {
                return $( "<li></li>" )
                    .data( "item.autocomplete", item )
                    .append( "<a>" + item.label + "</a>" )
                    .appendTo( ul );
            };

            this.button = $( "<button type='button'>&nbsp;</button>" )
                .attr( "tabIndex", -1 )
                .attr( "title", "Show All Items" )
                .insertAfter( input )
                .button({
                    icons: {
                        primary: "ui-icon-triangle-1-s"
                    },
                    text: false						
                })
                .removeClass( "ui-corner-all" )
                .addClass( "ui-corner-right ui-button-icon" )
                .click(function() {
                    // close if already visible
                    if ( input.autocomplete( "widget" ).is( ":visible" ) ) {
                        input.autocomplete( "close" );
                        return;
                    }

                    // work around a bug (likely same cause as #5265)
                    $( this ).blur();

                    // pass empty string as value to search for, displaying all results
                    input.autocomplete( "search", "" );
                    input.focus();
                });
        input.attr( 'id', $(select).attr( 'id' )+'-input' );
    
        },

        destroy: function() {
            this.input.remove();
            this.button.remove();
            this.element.show();
            $.Widget.prototype.destroy.call( this );
        }
    });
})( jQuery );

$(document).ready(function(){

$( "#Medstemp0DrugId" ).combobox();
$( "#Medstemp1DrugId" ).combobox();
$( "#Medstemp2DrugId" ).combobox();
$( "#Medstemp3DrugId" ).combobox();
$( "#Medstemp4DrugId" ).combobox();
$( "#Medstemp5DrugId" ).combobox();
$( "#Medstemp6DrugId" ).combobox();
$( "#Medstemp7DrugId" ).combobox();
$( "#Medstemp8DrugId" ).combobox();
$( "#Medstemp9DrugId" ).combobox();

$(".numericdec").numeric();

//Initial - Question 1 - if No then disabled  
$('#QuestionnaireTreatmentTreatment1011').click(function() {
    $('#treatquestsectionrow1 :input').attr('disabled', true);
    $('#treatquestsectionrow3 :input').attr('disabled', true);
    $('#treatquestsectionrow4 :input').attr('disabled', true);
    $('#treatquestsectionrow5 :input').attr('disabled', true);
    $('#treatquestsectionrow6 :input').attr('disabled', true);
    $('#treatquestsectionrow7 :input').attr('disabled', true);
});

//Initial - Question 1 - if Yes then show-enable the rest of the questions 
$('#QuestionnaireTreatmentTreatment1010').click(function() {
    //$('#treatquestsectionrow1 :input').removeAttr('disabled');		
    $('#treatquestsectionrow1 :input').prop('disabled', false);	
    $('#treatquestsectionrow3 :input').prop('disabled', false);	
    $('#treatquestsectionrow4 :input').prop('disabled', false);	
    $('#treatquestsectionrow5 :input').prop('disabled', false);	
    $('#treatquestsectionrow6 :input').prop('disabled', false);	
    $('#treatquestsectionrow7 :input').prop('disabled', false);			
});	

//FollowUp - Question 1 - if No then disabled  
$('#QuestionnaireTreatmentTreatment1045').click(function() {
    $('#treatquestsectionrow1 :input').attr('disabled', true);
    $('#treatquestsectionrow3 :input').attr('disabled', true);
    $('#treatquestsectionrow4 :input').attr('disabled', true);
    $('#treatquestsectionrow5 :input').attr('disabled', true);
    $('#Medstemp0DrugId-input').val('');
    $('#Medstemp1DrugId-input').val('');
    $('#Medstemp2DrugId-input').val('');
    $('#Medstemp3DrugId-input').val('');
    $('#Medstemp4DrugId-input').val('');
});

//FollowUp - Question 1 - if Yes then show-enable the rest of the questions 
$('#QuestionnaireTreatmentTreatment1044').click(function() {
    //$('#treatquestsectionrow1 :input').removeAttr('disabled');		
    $('#treatquestsectionrow1 :input').prop('disabled', false);	
    $('#treatquestsectionrow3 :input').prop('disabled', false);	
    $('#treatquestsectionrow4 :input').prop('disabled', false);	
    $('#treatquestsectionrow5 :input').prop('disabled', false);			
});	

//Initial - Question 2 Enable the Custome Meds textbox
$('#Medstemp0Newmed').click(function() {
    if($('#Medstemp0Newmed').is(':checked'))
    {				
        $('#customemeds0').show();
        $('#Medstemp0DrugId-input').val('');
        $('#Medstemp0Customemeds').focus().val('');								
    }
    else
    {
        $('#customemeds0').hide();
        $('#Medstemp0Customemeds').val('');
        $('#Medstemp0DrugId-input').focus().val('');
    }
});

$('#Medstemp1Newmed').click(function() {
    if($('#Medstemp1Newmed').is(':checked'))
    {				
        $('#customemeds1').show();
        $('#Medstemp1DrugId-input').val('');
        $('#Medstemp1Customemeds').focus().val('');			
    }
    else
    {
        $('#customemeds1').hide();
        $('#Medstemp1Customemeds').val('');
        $('#Medstemp1DrugId-input').focus().val('');			
    }
});

$('#Medstemp2Newmed').click(function() {
    if($('#Medstemp2Newmed').is(':checked'))
    {				
        $('#customemeds2').show();
        $('#Medstemp2DrugId-input').val('');
        $('#Medstemp2Customemeds').focus().val('');			
    }
    else
    {
        $('#customemeds2').hide();
        $('#Medstemp2Customemeds').val('');
        $('#Medstemp2DrugId-input').focus().val('');			
    }
});

$('#Medstemp3Newmed').click(function() {
    if($('#Medstemp3Newmed').is(':checked'))
    {				
        $('#customemeds3').show();
        $('#Medstemp3DrugId-input').val('');
        $('#Medstemp3Customemeds').focus().val('');			
    }
    else
    {
        $('#customemeds3').hide();
        $('#Medstemp3Customemeds').val('');
        $('#Medstemp3DrugId-input').focus().val('');			
    }
});

$('#Medstemp4Newmed').click(function() {
    if($('#Medstemp4Newmed').is(':checked'))
    {				
        $('#customemeds4').show();
        $('#Medstemp4DrugId-input').val('');
        $('#Medstemp4Customemeds').focus().val('');			
    }
    else
    {
        $('#customemeds4').hide();
        $('#Medstemp4Customemeds').val('');
        $('#Medstemp4DrugId-input').focus().val('');			
    }
});	

$('#Medstemp0DrugId-input').click(function() {			
        $('#customemeds0').hide();			
        $("#Medstemp0Newmed").removeAttr("checked"); 
});

$('#Medstemp1DrugId-input').click(function() {			
        $('#customemeds1').hide();			
        $("#Medstemp1Newmed").removeAttr("checked"); 
}); 

$('#Medstemp2DrugId-input').click(function() {			
        $('#customemeds2').hide();			
        $("#Medstemp2Newmed").removeAttr("checked"); 
});

$('#Medstemp3DrugId-input').click(function() {			
        $('#customemeds3').hide();			
        $("#Medstemp3Newmed").removeAttr("checked"); 
});

$('#Medstemp4DrugId-input').click(function() {			
        $('#customemeds4').hide();			
        $("#Medstemp4Newmed").removeAttr("checked"); 
}); 

//Initial - Question 3 - if Yes then show nonprescripcompounds textbox
$('#QuestionnaireTreatmentNonprescripCompounds1015').click(function() {
        $('#nonprescripcompounds').show();


}); 

//Initial - Question 3 - if Non then hide nonprescripcompounds textbox
$('#QuestionnaireTreatmentNonprescripCompounds1016').click(function() {
        $('#nonprescripcompounds').hide();
});  

//FollowUp - Question 3 - if Yes then show nonprescripcompounds textbox
$('#QuestionnaireTreatmentNonprescripCompounds1049').click(function() {
        $('#nonprescripcompounds').show();

}); 	  

//FollowUp - Question 3 - if Non then hide nonprescripcompounds textbox
$('#QuestionnaireTreatmentNonprescripCompounds1050').click(function() {

        $('#nonprescripcompounds').hide();
});	

//Initial - Question 5 - if No then disable Question 6 and 7
$('#QuestionnaireTreatmentSideEffects1019').click(function() {
    $('#QuestionnaireTreatmentStopingDrugs1020').attr('checked', false);
    $('#QuestionnaireTreatmentStopingDrugs1021').attr('checked', false);		
    $('#QuestionnaireTreatmentSideEffectsChaine19').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine20').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine21').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine22').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine23').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine24').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine25').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine26').removeAttr('checked');		
    $('#QuestionnaireTreatmentSideEffectsChaine27').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine28').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine29').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine30').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine31').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine32').removeAttr('checked');		
    $('#treatquestsectionrow5 :input').attr('disabled', true);
    $('#treatquestsectionrow6 :input').attr('disabled', true);
    $('#customesideeff').hide();
});

//Initial - Question 5 - if Yes then show-enable Question 6
$('#QuestionnaireTreatmentSideEffects1018').click(function() {		
    //$('#treatquestsectionrow5 :input').removeAttr('disabled');
    $('#treatquestsectionrow5 :input').prop('disabled', false);
    $('#treatquestsectionrow6 :input').prop('disabled', false);
});	 
//FollowUp - Question 4 - if Yes then show-enable Question 5
$('#QuestionnaireTreatmentSideEffects1051').click(function() {
    $('#treatquestsectionrow4 :input').prop('disabled', false);
    $('#treatquestsectionrow5 :input').prop('disabled', false);
});		

//Followup - Question 4 - if No then disable Question 5 and 6
$('#QuestionnaireTreatmentSideEffects1052').click(function() {
    $('#QuestionnaireTreatmentStopingDrugs1053').attr('checked', false);
    $('#QuestionnaireTreatmentStopingDrugs1054').attr('checked', false);		
    $('#QuestionnaireTreatmentSideEffectsChaine33').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine34').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine35').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine36').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine37').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine38').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine39').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine40').removeAttr('checked');		
    $('#QuestionnaireTreatmentSideEffectsChaine41').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine42').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine43').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine44').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine45').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine46').removeAttr('checked');		
    $('#treatquestsectionrow4 :input').attr('disabled', true);
    $('#treatquestsectionrow5 :input').attr('disabled', true);
    $('#customesideeff').hide();
});		 

//Initial - Question 6 - if No then disable Question 7
$('#QuestionnaireTreatmentStopingDrugs1021').click(function() {
    $('#treatquestsectionrow6 :input').attr('disabled', true);
    $('#QuestionnaireTreatmentSideEffectsChaine19').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine20').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine21').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine22').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine23').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine24').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine25').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine26').removeAttr('checked');		
    $('#QuestionnaireTreatmentSideEffectsChaine27').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine28').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine29').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine30').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine31').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine32').removeAttr('checked');
    $('#customesideeff').hide();		
});	

//Initial - Question 6 - if Yes then enable Question 7
$('#QuestionnaireTreatmentStopingDrugs1020').click(function() {
    $('#treatquestsectionrow6 :input').prop('disabled', false);
});	
    
//FollowUp - Question 5 - if No then disable Question 6
$('#QuestionnaireTreatmentStopingDrugs1054').click(function() {
    $('#treatquestsectionrow5 :input').attr('disabled', true);
    $('#QuestionnaireTreatmentSideEffectsChaine33').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine34').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine35').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine36').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine37').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine38').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine39').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine40').removeAttr('checked');		
    $('#QuestionnaireTreatmentSideEffectsChaine41').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine42').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine43').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine44').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine45').removeAttr('checked');
    $('#QuestionnaireTreatmentSideEffectsChaine46').removeAttr('checked');
    $('#customesideeff').hide();
});	

//FollowUp - Question 5 - if Yes then enable Question 6
$('#QuestionnaireTreatmentStopingDrugs1053').click(function() {
    $('#treatquestsectionrow5 :input').prop('disabled', false);
});	
    
//Initial - Question 7 Enable the Custome Side effects textbox
$('#QuestionnaireTreatmentSideEffectsChaine32').click(function() {
    if($('#QuestionnaireTreatmentSideEffectsChaine32').is(':checked'))
    {
        $('#customesideeff').show();
    }
    else
    {
        $('#customesideeff').hide();
    }
});

//FollowUp - Question 5 Enable the Custome Side effects textbox
$('#QuestionnaireTreatmentSideEffectsChaine46').click(function() {
    if($('#QuestionnaireTreatmentSideEffectsChaine46').is(':checked'))
    {
        $('#customesideeff').show();
    }
    else
    {
        $('#customesideeff').hide();
    }
});	

//Initial - Question 10 - if No then disabled Question11
$('#QuestionnaireTreatmentPsychotherapy1040').click(function() {
    $('#treatquestsectionrow10 :input').attr('disabled', true);
});

//Initial - Question 10 - if Yes then show-enable Question11 
$('#QuestionnaireTreatmentPsychotherapy1039').click(function() {
    $('#treatquestsectionrow10 :input').prop('disabled', false);
});	 

//FollowUp - Question 8 - if No then disabled Question 9
$('#QuestionnaireTreatmentPsychotherapy1070').click(function() {
    $('#treatquestsectionrow8 :input').attr('disabled', true);
});		

//FollowUp - Question 8 - if Yes then show-enable Question 9   
$('#QuestionnaireTreatmentPsychotherapy1069').click(function() {
    $('#treatquestsectionrow8 :input').prop('disabled', false);
});	

//Initial - Question 11 Enable the Custome Therapy textbox
$('#thpywhom101').live('change', function() 
{
    if($(this).val().length != 0) {
        typetherapist1 = $(this).val();
        if( typetherapist1 == 7 ) 
        {
            $('#custometherapy1').show();
        }
        else
        {
            $('#custometherapy1').hide();
        }			
      }
    else
    {	
        $('#custometherapy1').hide();
    }	  
});	

//FollowUp - Question 9 Enable the Custome Therapy textbox
$('#thpywhom81').live('change', function() 
{
    if($(this).val().length != 0) {
        typetherapist1 = $(this).val();
        if( typetherapist1 == 14 ) 
        {
            $('#custometherapy1').show();
        }
        else
        {
            $('#custometherapy1').hide();
        }			
      }
    else
    {	
        $('#custometherapy1').hide();
    }	  
});		

//Initial - Question 11 Enable the Custome Therapy textbox
$('#thpywhom102').live('change', function() 
{
    if($(this).val().length != 0) 
    {
        typetherapist2 = $(this).val();
        if( typetherapist2 == 7 ) 
        {
            $('#custometherapy2').show();
        }
        else
        {
            $('#custometherapy2').hide();
        }		
    }
    else
    {	
        $('#custometherapy2').hide();
    }	  
});	

//FollowUp - Question 9 Enable the Custome Therapy textbox
$('#thpywhom82').live('change', function() 
{
    if($(this).val().length != 0) 
    {
        typetherapist2 = $(this).val();
        if( typetherapist2 == 14 ) 
        {
            $('#custometherapy2').show();
        }
        else
        {
            $('#custometherapy2').hide();
        }		
    }
    else
    {	
        $('#custometherapy2').hide();
    }	  
});	

//Initial - Question 11 Enable the Custome Therapy textbox
$('#thpywhom103').live('change', function() 
{
    if($(this).val().length != 0) 
    {
        typetherapist3 = $(this).val();
//		alert(typetherapist);
        if( typetherapist3 == 7 ) 
        {
            $('#custometherapy3').show();
        }
        else
        {
            $('#custometherapy3').hide();
        }		
    }
    else
    {	
        $('#custometherapy3').hide();
    }	  
});	

//FollowUp - Question 9 Enable the Custome Therapy textbox
$('#thpywhom83').live('change', function() 
{
    if($(this).val().length != 0) 
    {
        typetherapist3 = $(this).val();
        if( typetherapist3 == 14 ) 
        {
            $('#custometherapy3').show();
        }
        else
        {
            $('#custometherapy3').hide();
        }		
    }
    else
    {	
        $('#custometherapy3').hide();
    }	  
});		

//Initial - Question 11 Enable the Custome Therapy textbox
$('#thpywhom104').live('change', function() 
{
if($(this).val().length != 0) 
    {
        typetherapist4 = $(this).val();
//		alert(typetherapist);
        if( typetherapist4 == 7 ) 
        {
            $('#custometherapy4').show();
        }
        else
        {
            $('#custometherapy4').hide();
        }			
    }
    else
    {	
        $('#custometherapy4').hide();
    }	  
});	

//FollowUp - Question 9 Enable the Custome Therapy textbox
$('#thpywhom84').live('change', function() 
{
if($(this).val().length != 0) 
    {
        typetherapist4 = $(this).val();
//		alert(typetherapist);
        if( typetherapist4 == 14 ) 
        {
            $('#custometherapy4').show();
        }
        else
        {
            $('#custometherapy4').hide();
        }			
    }
    else
    {	
        $('#custometherapy4').hide();
    }	  
});		

//Initial - Question 11 Enable the Custome Therapy textbox
$('#thpywhom105').live('change', function() 
{
    if($(this).val().length != 0) 
    {
        typetherapist5 = $(this).val();
//		alert(typetherapist);
        if( typetherapist5 == 7 ) 
        {
            $('#custometherapy5').show();
        }
        else
        {
            $('#custometherapy5').hide();
        }	
    }
    else
    {	
        $('#custometherapy5').hide();
    }
});	

//FollowUp - Question 9 Enable the Custome Therapy textbox
$('#thpywhom85').live('change', function() 
{
    if($(this).val().length != 0) 
    {
        typetherapist5 = $(this).val();
//		alert(typetherapist);
        if( typetherapist5 == 14 ) 
        {
            $('#custometherapy5').show();
        }
        else
        {
            $('#custometherapy5').hide();
        }	
    }
    else
    {	
        $('#custometherapy5').hide();
    }
});		

//QuestionnaireTreatmentAddForm  
$('.submit').click(function()
{	
    //Treatment Questionnaire Initial
    if ($('#QuestionnaireTreatmentQuestionnaireId').val() == 4)
    {		
        if(!validateTreatQuestInitial()) {
            return false;
        }
    }

    //Treatment Questionnaire Follow up
    if ($('#QuestionnaireTreatmentQuestionnaireId').val() == 5)
    {		
        if(!validateTreatQuestFollow()) {
            return false;
        }
    }
});
});

function validateTreatQuestInitial() {

if( ($('#QuestionnaireTreatmentTreatment1011').is(":not(':checked')") && $('#QuestionnaireTreatmentTreatment1010').is(":not(':checked')")) ||
($('#QuestionnaireTreatmentPsychotherapy1039').is(":not(':checked')") && $('#QuestionnaireTreatmentPsychotherapy1040').is(":not(':checked')"))) 
{
    alert('You have to answer at least the questions 1. and 10.');		
    return false;
} 
else
{
    //Q.1 No
    if($('#QuestionnaireTreatmentTreatment1011').is(':checked'))
    {	
        //Validate the Q.3 is not empty - NonprescripCompounds
        if ($('#QuestionnaireTreatmentNonprescripCompounds1015').is(":not(':checked')") && $('#QuestionnaireTreatmentNonprescripCompounds1016').is(":not(':checked')"))
        {
            alert('You have to answer the question 3.');		
            return false;					
        }
        //Then validate if Q10 = Yes
        if($('#QuestionnaireTreatmentPsychotherapy1039').is(':checked'))
        {
            // Then make sure that at least one Therapy type has been selected.
            if( !$('#thpywhom101').val() && !$('#thpywhom102').val() && !$('#thpywhom103').val() && !$('#thpywhom104').val() && !$('#thpywhom105').val()) 
            {
                alert('Please fill out at least one type of therapy');
                return false;				
            }
            else
            {					
                // validate the values of the therapy select list
                if (($('#thpywhom101').val() && !$('#thpyfrec101').val()) || ($('#thpywhom101').val() && $('#thpyfrec101').val() && !$('#Therapytemp0DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 1');
                    //alert ($('#thpywhom101').val() + '' + $('#thpyfrec101').val() + '' + $('#Therapytemp0DurationOfSession').val());						
                    return false;						
                }
                if (($('#thpywhom102').val() && !$('#thpyfrec102').val()) || ($('#thpywhom102').val() && $('#thpyfrec102').val() && !$('#Therapytemp1DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 2');
                    return false;						
                }
                if (($('#thpywhom103').val() && !$('#thpyfrec103').val()) || ($('#thpywhom103').val() && $('#thpyfrec103').val() && !$('#Therapytemp2DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 3');
                    return false;						
                }
                if (($('#thpywhom104').val() && !$('#thpyfrec104').val()) || ($('#thpywhom104').val() && $('#thpyfrec104').val() && !$('#Therapytemp3DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 4');
                    return false;						
                }
                if (($('#thpywhom105').val() && !$('#thpyfrec105').val()) || ($('#thpywhom105').val() && $('#thpyfrec105').val() && !$('#Therapytemp4DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 5');
                    return false;						

                }	
                if (($('#thpywhom101').val() == 7 && !$('#Therapytemp0Custometherapy').val()) || ($('#thpywhom102').val() == 7 && !$('#Therapytemp1Custometherapy').val()) || ($('#thpywhom103').val() == 7 && !$('#Therapytemp2Custometherapy').val()) || 
                    ($('#thpywhom104').val() == 7 && !$('#Therapytemp3Custometherapy').val()) || ($('#thpywhom105').val() == 7 && !$('#Therapytemp4Custometherapy').val()))
                {
                    alert('Please enter the Custome Therapy');
                    return false;						
                }					
            }
        }
    }
    else
    {
    //Q.1 Yes
        // Then make sure that at least one Med-Drug type has been selected.

        if( !$('#Medstemp0DrugId').val() && !$('#Medstemp0Customemeds').val() && !$('#Medstemp1DrugId').val() && !$('#Medstemp1Customemeds').val() && 
            !$('#Medstemp2DrugId').val() && !$('#Medstemp2Customemeds').val() && !$('#Medstemp3DrugId').val() && !$('#Medstemp3Customemeds').val() &&				
            !$('#Medstemp4DrugId').val() && !$('#Medstemp4Customemeds').val())
        {
            alert('Please fill out at least one prescribed medication');
            return false;			
        }
        
        if(($('#QuestionnaireTreatmentNonprescripCompounds1015').is(":not(':checked')") && $('#QuestionnaireTreatmentNonprescripCompounds1016').is(":not(':checked')")) || 
            (!$('#qsttreat_improv3').val()) || ($('#QuestionnaireTreatmentSideEffects1018').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffects1019').is(":not(':checked')"))
            )
        {
            alert('Please complete all the missing items (3,4,5)');
            return false;					
        }
        //Q.6 Yes
        if($('#QuestionnaireTreatmentStopingDrugs1020').is(':checked')) {
            //Verifier that at least one side effect has been selected
            if ($('#QuestionnaireTreatmentSideEffectsChaine19').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine20').is(":not(':checked')") && 
                $('#QuestionnaireTreatmentSideEffectsChaine21').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine22').is(":not(':checked')") && 
                $('#QuestionnaireTreatmentSideEffectsChaine23').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine24').is(":not(':checked')") && 
                $('#QuestionnaireTreatmentSideEffectsChaine25').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine26').is(":not(':checked')") && 
                $('#QuestionnaireTreatmentSideEffectsChaine27').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine28').is(":not(':checked')") &&
                $('#QuestionnaireTreatmentSideEffectsChaine29').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine30').is(":not(':checked')") &&
                $('#QuestionnaireTreatmentSideEffectsChaine31').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine32').is(":not(':checked')"))
            {
                alert('Please select at least one side effect');
                return false;				
            }			
        }
        //Then validate if Q10 = Yes Psychotherapy
        if($('#QuestionnaireTreatmentPsychotherapy1039').is(':checked'))
        {
            // Then make sure that at least one Therapy type has been selected.
            if( !$('#thpywhom101').val() && !$('#thpywhom102').val() && !$('#thpywhom103').val() && !$('#thpywhom104').val() && !$('#thpywhom105').val()) 
            {
                alert('Please fill out at least one type of therapy');
                return false;				
            }
            else
            {					
                // validate the values of the therapy select list
                if (($('#thpywhom101').val() && !$('#thpyfrec101').val()) || ($('#thpywhom101').val() && $('#thpyfrec101').val() && !$('#Therapytemp0DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 1');
                    //alert ($('#thpywhom101').val() + '' + $('#thpyfrec101').val() + '' + $('#TherapyTreatment0DurationOfSession').val());
                    return false;						
                }
                if (($('#thpywhom102').val() && !$('#thpyfrec102').val()) || ($('#thpywhom102').val() && $('#thpyfrec102').val() && !$('#Therapytemp1DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 2');
                    return false;						
                }
                if (($('#thpywhom103').val() && !$('#thpyfrec103').val()) || ($('#thpywhom103').val() && $('#thpyfrec103').val() && !$('#Therapytemp2DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 3');
                    return false;						
                }
                if (($('#thpywhom104').val() && !$('#thpyfrec104').val()) || ($('#thpywhom104').val() && $('#thpyfrec104').val() && !$('#Therapytemp3DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 4');
                    return false;						
                }
                if (($('#thpywhom105').val() && !$('#thpyfrec105').val()) || ($('#thpywhom105').val() && $('#thpyfrec105').val() && !$('#Therapytemp4DurationOfSession').val()))
                {
                    alert('Please complete all the items for the therapy row 5');
                    return false;
                }
                if (($('#thpywhom101').val() == 7 && !$('#Therapytemp0Custometherapy').val()) || ($('#thpywhom102').val() == 7 && !$('#Therapytemp1Custometherapy').val()) || ($('#thpywhom103').val() == 7 && !$('#Therapytemp2Custometherapy').val()) || 
                    ($('#thpywhom104').val() == 7 && !$('#Therapytemp3Custometherapy').val()) || ($('#thpywhom105').val() == 7 && !$('#Therapytemp4Custometherapy').val()))
                {
                    alert('Please enter the Custome Therapy');
                    return false;						
                }					
            }
        }			
    }
}
return true;
}

function validateTreatQuestFollow()  {

//Validate the questions 1 and 8 are answered... 
if( ($('#QuestionnaireTreatmentTreatment1045').is(":not(':checked')") && $('#QuestionnaireTreatmentTreatment1044').is(":not(':checked')")) ||
($('#QuestionnaireTreatmentPsychotherapy1069').is(":not(':checked')") && $('#QuestionnaireTreatmentPsychotherapy1070').is(":not(':checked')"))) 
{
    alert('You have to answer at least the questions 1. and 8.');		
    return false;
} 
else
{
    //Q.1 = No
    if($('#QuestionnaireTreatmentTreatment1045').is(':checked'))
    {			
        //Validate the Q.3 is not empty - NonprescripCompounds
        if ($('#QuestionnaireTreatmentNonprescripCompounds1049').is(":not(':checked')") && $('#QuestionnaireTreatmentNonprescripCompounds1050').is(":not(':checked')"))
        {
            alert('You have to answer the question 3.');		
            return false;					
        }

        //Q.8 Yes - Psychotherapy
        if($('#QuestionnaireTreatmentPsychotherapy1069').is(':checked'))
        {		
            // Then make sure that at least one Therapy type has been selected.
            if( !$('#thpywhom81').val() && !$('#thpywhom82').val() && !$('#thpywhom83').val() && !$('#thpywhom84').val() && !$('#thpywhom85').val()) 
            {
                alert('Please fill out at least one type of therapy');
                return false;				
            }
            else
            {					
                // validate the values of the therapy select list
                if (($('#thpywhom81').val() && !$('#thpyfrec81').val()) || ($('#thpywhom81').val() && $('#thpyfrec81').val() && $('#Therapytemp0DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 1');
                    return false;						
                }
                if (($('#thpywhom82').val() && !$('#thpyfrec82').val()) || ($('#thpywhom82').val() && $('#thpyfrec82').val() && $('#Therapytemp1DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 2');
                    return false;						
                }
                if (($('#thpywhom83').val() && !$('#thpyfrec83').val()) || ($('#thpywhom83').val() && $('#thpyfrec83').val() && $('#Therapytemp2DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 3');
                    return false;						
                }
                if (($('#thpywhom84').val() && !$('#thpyfrec84').val()) || ($('#thpywhom74').val() && $('#thpyfrec84').val() && $('#Therapytemp3DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 4');
                    return false;						
                }
                if (($('#thpywhom85').val() && !$('#thpyfrec85').val()) || ($('#thpywhom75').val() && $('#thpyfrec85').val() && $('#Therapytemp4DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 5');
                    return false;						
                }	
                if (($('#thpywhom81').val() == 7 && !$('#custometherapy1').val()) || ($('#thpywhom82').val() == 7 && !$('#custometherapy2').val()) || ($('#thpywhom83').val() == 7 && !$('#custometherapy3').val()) || 
                    ($('#thpywhom84').val() == 7 && !$('#custometherapy4').val()) || ($('#thpywhom85').val() == 7 && !$('#custometherapy5').val()))
                {
                    alert('Please enter the Custome Therapy');
                    return false;						
                }					
            }
        }					
    } 
    else
    {
    //Q.1 = Yes		
        //Validate the Q.2 is not empty (meds list...) 
        // Then make sure that at least one Med-Drug type has been selected.
        if( !$('#Medstemp0DrugId').val() && !$('#Medstemp0Customemeds').val() && !$('#Medstemp1DrugId').val() && !$('#Medstemp1Customemeds').val() && 
            !$('#Medstemp2DrugId').val() && !$('#Medstemp2Customemeds').val() && !$('#Medstemp3DrugId').val() && !$('#Medstemp3Customemeds').val() &&				
            !$('#Medstemp4DrugId').val() && !$('#Medstemp4Customemeds').val())
        {
            alert('Please fill out at least one prescribed medication');
            return false;			
        }			
    
        if(($('#QuestionnaireTreatmentNonprescripCompounds1049').is(":not(':checked')") && $('#QuestionnaireTreatmentNonprescripCompounds1050').is(":not(':checked')")) || 
            ($('#QuestionnaireTreatmentSideEffects1051').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffects1052').is(":not(':checked')")) ||
            ($('#QuestionnaireTreatmentPsychotherapy1069').is(":not(':checked')") && $('#QuestionnaireTreatmentPsychotherapy1070').is(":not(':checked')"))
            )
        {
            alert('Please complete all the missing items (3,4 and 8.)');
            return false;					
        }
        
        //Q.4 = Yes
        if($('#QuestionnaireTreatmentSideEffects1051').is(':checked')) {
            //Validate the Q.5 is not empty (have you considered that you might have to stop taking ...) 
            if ($('#QuestionnaireTreatmentStopingDrugs1053').is(":not(':checked')") && $('#QuestionnaireTreatmentStopingDrugs1054').is(":not(':checked')"))
            {
                alert('Complete the Item 5.');		
                return false;					
            }		
        
        }
    
        //Q.5 Yes
        if($('#QuestionnaireTreatmentStopingDrugs1053').is(':checked')) {
            //Verifier that at least one side effect has been selected
            if ($('#QuestionnaireTreatmentSideEffectsChaine33').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine34').is(":not(':checked')") && 
                $('#QuestionnaireTreatmentSideEffectsChaine35').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine36').is(":not(':checked')") && 
                $('#QuestionnaireTreatmentSideEffectsChaine37').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine38').is(":not(':checked')") && 
                $('#QuestionnaireTreatmentSideEffectsChaine39').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine40').is(":not(':checked')") && 
                $('#QuestionnaireTreatmentSideEffectsChaine41').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine42').is(":not(':checked')") &&
                $('#QuestionnaireTreatmentSideEffectsChaine43').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine44').is(":not(':checked')") &&
                $('#QuestionnaireTreatmentSideEffectsChaine45').is(":not(':checked')") && $('#QuestionnaireTreatmentSideEffectsChaine46').is(":not(':checked')"))
            {
                alert('Please select at least one side effect');
                return false;				
            }			
        }

        //Q.8 Yes - Psychotherapy
        if($('#QuestionnaireTreatmentPsychotherapy1069').is(':checked'))
        {		
            // Then make sure that at least one Therapy type has been selected.
            if( !$('#thpywhom81').val() && !$('#thpywhom82').val() && !$('#thpywhom83').val() && !$('#thpywhom84').val() && !$('#thpywhom85').val()) 
            {
                alert('Please fill out at least one type of therapy');
                return false;				
            }
            else
            {					
                // validate the values of the therapy select list
                if (($('#thpywhom81').val() && !$('#thpyfrec81').val()) || ($('#thpywhom81').val() && $('#thpyfrec81').val() && $('#Therapytemp0DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 1');
                    return false;						
                }
                if (($('#thpywhom82').val() && !$('#thpyfrec82').val()) || ($('#thpywhom82').val() && $('#thpyfrec82').val() && $('#Therapytemp1DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 2');
                    return false;						
                }
                if (($('#thpywhom83').val() && !$('#thpyfrec83').val()) || ($('#thpywhom83').val() && $('#thpyfrec83').val() && $('#Therapytemp2DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 3');
                    return false;						
                }
                if (($('#thpywhom84').val() && !$('#thpyfrec84').val()) || ($('#thpywhom74').val() && $('#thpyfrec84').val() && $('#Therapytemp3DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 4');
                    return false;						
                }
                if (($('#thpywhom85').val() && !$('#thpyfrec85').val()) || ($('#thpywhom75').val() && $('#thpyfrec85').val() && $('#Therapytemp4DurationOfSession').val() == ""))
                {
                    alert('Please complete all the items for a therapy row 5');
                    return false;						
                }
                if (($('#thpywhom81').val() == 7 && !$('#custometherapy1').val()) || ($('#thpywhom82').val() == 7 && !$('#custometherapy2').val()) || ($('#thpywhom83').val() == 7 && !$('#custometherapy3').val()) || 
                    ($('#thpywhom84').val() == 7 && !$('#custometherapy4').val()) || ($('#thpywhom85').val() == 7 && !$('#custometherapy5').val()))
                {
                    alert('Please enter the Custome Therapy');
                    return false;						
                }					
            }
        }			
    
    }				

}		
return true;
}